/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.annotation.spring.scan;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.ai.mcp.annotation.spring.scan.AbstractAnnotatedMethodBeanPostProcessor;
import org.springframework.ai.mcp.annotation.spring.scan.AnnotatedMethodDiscovery;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.log.LogAccessor;

public class AbstractAnnotatedMethodBeanFactoryInitializationAotProcessor
extends AnnotatedMethodDiscovery
implements BeanFactoryInitializationAotProcessor {
    private static final LogAccessor logger = new LogAccessor(AbstractAnnotatedMethodBeanPostProcessor.class);

    public AbstractAnnotatedMethodBeanFactoryInitializationAotProcessor(Set<Class<? extends Annotation>> targetAnnotations) {
        super(targetAnnotations);
    }

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        ArrayList<Class> types = new ArrayList<Class>();
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            Set<Class<? extends Annotation>> classes;
            Class beanClass = beanFactory.getType(beanName);
            if (beanClass == null || (classes = this.scan(beanClass)).isEmpty()) continue;
            types.add(beanClass);
        }
        return (generationContext, beanFactoryInitializationCode) -> {
            RuntimeHints runtimeHints = generationContext.getRuntimeHints();
            for (Class typeReference : types) {
                runtimeHints.reflection().registerType(typeReference, MemberCategory.values());
                logger.info((CharSequence)("registering " + typeReference.getName() + " for reflection"));
            }
        };
    }
}

