/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.annotation.spring;

import io.modelcontextprotocol.spec.McpError;
import io.modelcontextprotocol.spec.McpSchema;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpElicitation;
import org.springaicommunity.mcp.annotation.McpLogging;
import org.springaicommunity.mcp.annotation.McpProgress;
import org.springaicommunity.mcp.annotation.McpPromptListChanged;
import org.springaicommunity.mcp.annotation.McpResourceListChanged;
import org.springaicommunity.mcp.annotation.McpSampling;
import org.springaicommunity.mcp.annotation.McpToolListChanged;
import org.springaicommunity.mcp.method.changed.prompt.SyncPromptListChangedSpecification;
import org.springaicommunity.mcp.method.changed.resource.SyncResourceListChangedSpecification;
import org.springaicommunity.mcp.method.changed.tool.SyncToolListChangedSpecification;
import org.springaicommunity.mcp.method.elicitation.SyncElicitationSpecification;
import org.springaicommunity.mcp.method.logging.SyncLoggingSpecification;
import org.springaicommunity.mcp.method.progress.SyncProgressSpecification;
import org.springaicommunity.mcp.method.sampling.SyncSamplingSpecification;
import org.springframework.ai.mcp.annotation.spring.AbstractClientMcpHandlerRegistry;
import org.springframework.ai.mcp.annotation.spring.SyncMcpAnnotationProviders;
import org.springframework.beans.factory.SmartInitializingSingleton;

public class ClientMcpSyncHandlersRegistry
extends AbstractClientMcpHandlerRegistry
implements SmartInitializingSingleton {
    private static final Logger logger = LoggerFactory.getLogger(ClientMcpSyncHandlersRegistry.class);
    private final Map<String, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult>> samplingHandlers = new HashMap<String, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult>>();
    private final Map<String, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult>> elicitationHandlers = new HashMap<String, Function<McpSchema.ElicitRequest, McpSchema.ElicitResult>>();
    private final Map<String, List<Consumer<McpSchema.LoggingMessageNotification>>> loggingHandlers = new HashMap<String, List<Consumer<McpSchema.LoggingMessageNotification>>>();
    private final Map<String, List<Consumer<McpSchema.ProgressNotification>>> progressHandlers = new HashMap<String, List<Consumer<McpSchema.ProgressNotification>>>();
    private final Map<String, List<Consumer<List<McpSchema.Tool>>>> toolListChangedHandlers = new HashMap<String, List<Consumer<List<McpSchema.Tool>>>>();
    private final Map<String, List<Consumer<List<McpSchema.Prompt>>>> promptListChangedHandlers = new HashMap<String, List<Consumer<List<McpSchema.Prompt>>>>();
    private final Map<String, List<Consumer<List<McpSchema.Resource>>>> resourceListChangedHandlers = new HashMap<String, List<Consumer<List<McpSchema.Resource>>>>();

    public McpSchema.ClientCapabilities getCapabilities(String clientName) {
        return this.capabilitiesPerClient.getOrDefault(clientName, EMPTY_CAPABILITIES);
    }

    public McpSchema.CreateMessageResult handleSampling(String name, McpSchema.CreateMessageRequest samplingRequest) {
        logger.debug("Handling sampling request for client {}", (Object)name);
        Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> handler = this.samplingHandlers.get(name);
        if (handler != null) {
            return handler.apply(samplingRequest);
        }
        throw new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(Integer.valueOf(-32601), "Sampling not supported", Map.of("reason", "Client does not have sampling capability")));
    }

    public McpSchema.ElicitResult handleElicitation(String name, McpSchema.ElicitRequest elicitationRequest) {
        logger.debug("Handling elicitation request for client {}", (Object)name);
        Function<McpSchema.ElicitRequest, McpSchema.ElicitResult> handler = this.elicitationHandlers.get(name);
        if (handler != null) {
            return handler.apply(elicitationRequest);
        }
        throw new McpError(new McpSchema.JSONRPCResponse.JSONRPCError(Integer.valueOf(-32601), "Elicitation not supported", Map.of("reason", "Client does not have elicitation capability")));
    }

    public void handleLogging(String name, McpSchema.LoggingMessageNotification loggingMessageNotification) {
        logger.debug("Handling logging notification for client {}", (Object)name);
        List<Consumer<McpSchema.LoggingMessageNotification>> consumers = this.loggingHandlers.get(name);
        if (consumers == null) {
            return;
        }
        for (Consumer<McpSchema.LoggingMessageNotification> consumer : consumers) {
            consumer.accept(loggingMessageNotification);
        }
    }

    public void handleProgress(String name, McpSchema.ProgressNotification progressNotification) {
        logger.debug("Handling progress notification for client {}", (Object)name);
        List<Consumer<McpSchema.ProgressNotification>> consumers = this.progressHandlers.get(name);
        if (consumers == null) {
            return;
        }
        for (Consumer<McpSchema.ProgressNotification> consumer : consumers) {
            consumer.accept(progressNotification);
        }
    }

    public void handleToolListChanged(String name, List<McpSchema.Tool> updatedTools) {
        logger.debug("Handling tool list changed notification for client {}", (Object)name);
        List<Consumer<List<McpSchema.Tool>>> consumers = this.toolListChangedHandlers.get(name);
        if (consumers == null) {
            return;
        }
        for (Consumer<List<McpSchema.Tool>> consumer : consumers) {
            consumer.accept(updatedTools);
        }
    }

    public void handlePromptListChanged(String name, List<McpSchema.Prompt> updatedPrompts) {
        logger.debug("Handling prompt list changed notification for client {}", (Object)name);
        List<Consumer<List<McpSchema.Prompt>>> consumers = this.promptListChangedHandlers.get(name);
        if (consumers == null) {
            return;
        }
        for (Consumer<List<McpSchema.Prompt>> consumer : consumers) {
            consumer.accept(updatedPrompts);
        }
    }

    public void handleResourceListChanged(String name, List<McpSchema.Resource> updatedResources) {
        logger.debug("Handling resource list changed notification for client {}", (Object)name);
        List<Consumer<List<McpSchema.Resource>>> consumers = this.resourceListChangedHandlers.get(name);
        if (consumers == null) {
            return;
        }
        for (Consumer<List<McpSchema.Resource>> consumer : consumers) {
            consumer.accept(updatedResources);
        }
    }

    public void afterSingletonsInstantiated() {
        Map<Class<? extends Annotation>, Set<Object>> beansByAnnotation = this.getBeansByAnnotationType();
        List<SyncSamplingSpecification> samplingSpecs = SyncMcpAnnotationProviders.samplingSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpSampling.class)));
        for (SyncSamplingSpecification syncSamplingSpecification : samplingSpecs) {
            for (String client : syncSamplingSpecification.clients()) {
                logger.debug("Registering sampling handler for {}", (Object)client);
                this.samplingHandlers.put(client, syncSamplingSpecification.samplingHandler());
            }
        }
        List<SyncElicitationSpecification> elicitationSpecs = SyncMcpAnnotationProviders.elicitationSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpElicitation.class)));
        for (SyncElicitationSpecification syncElicitationSpecification : elicitationSpecs) {
            for (String client : syncElicitationSpecification.clients()) {
                logger.debug("Registering elicitation handler for {}", (Object)client);
                this.elicitationHandlers.put(client, syncElicitationSpecification.elicitationHandler());
            }
        }
        List<SyncLoggingSpecification> list = SyncMcpAnnotationProviders.loggingSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpLogging.class)));
        for (SyncLoggingSpecification loggingSpec : list) {
            for (String client : loggingSpec.clients()) {
                logger.debug("Registering logging handler for {}", (Object)client);
                this.loggingHandlers.computeIfAbsent(client, k -> new ArrayList()).add(loggingSpec.loggingHandler());
            }
        }
        List<SyncProgressSpecification> list2 = SyncMcpAnnotationProviders.progressSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpProgress.class)));
        for (SyncProgressSpecification progressSpec : list2) {
            for (String client : progressSpec.clients()) {
                logger.debug("Registering progress handler for {}", (Object)client);
                this.progressHandlers.computeIfAbsent(client, k -> new ArrayList()).add(progressSpec.progressHandler());
            }
        }
        List<SyncToolListChangedSpecification> toolsListChangedSpecs = SyncMcpAnnotationProviders.toolListChangedSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpToolListChanged.class)));
        for (SyncToolListChangedSpecification toolsListChangedSpec : toolsListChangedSpecs) {
            for (String client : toolsListChangedSpec.clients()) {
                logger.debug("Registering tool list changed handler for {}", (Object)client);
                this.toolListChangedHandlers.computeIfAbsent(client, k -> new ArrayList()).add(toolsListChangedSpec.toolListChangeHandler());
            }
        }
        List<SyncPromptListChangedSpecification> promptListChangedSpecs = SyncMcpAnnotationProviders.promptListChangedSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpPromptListChanged.class)));
        for (SyncPromptListChangedSpecification promptListChangedSpec : promptListChangedSpecs) {
            for (String client : promptListChangedSpec.clients()) {
                logger.debug("Registering prompt list changed handler for {}", (Object)client);
                this.promptListChangedHandlers.computeIfAbsent(client, k -> new ArrayList()).add(promptListChangedSpec.promptListChangeHandler());
            }
        }
        List<SyncResourceListChangedSpecification> resourceListChangedSpecs = SyncMcpAnnotationProviders.resourceListChangedSpecifications(new ArrayList<Object>((Collection)beansByAnnotation.get(McpResourceListChanged.class)));
        for (SyncResourceListChangedSpecification resourceListChangedSpec : resourceListChangedSpecs) {
            for (String client : resourceListChangedSpec.clients()) {
                logger.debug("Registering resource list changed handler for {}", (Object)client);
                this.resourceListChangedHandlers.computeIfAbsent(client, k -> new ArrayList()).add(resourceListChangedSpec.resourceListChangeHandler());
            }
        }
    }
}

