/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.reader.jsoup;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.DocumentReader;
import org.springframework.ai.reader.jsoup.config.JsoupDocumentReaderConfig;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class JsoupDocumentReader
implements DocumentReader {
    private final Resource htmlResource;
    private final JsoupDocumentReaderConfig config;

    public JsoupDocumentReader(String htmlResource) {
        this(new DefaultResourceLoader().getResource(htmlResource));
    }

    public JsoupDocumentReader(Resource htmlResource) {
        this(htmlResource, JsoupDocumentReaderConfig.defaultConfig());
    }

    public JsoupDocumentReader(String htmlResource, JsoupDocumentReaderConfig config) {
        this(new DefaultResourceLoader().getResource(htmlResource), config);
    }

    public JsoupDocumentReader(Resource htmlResource, JsoupDocumentReaderConfig config) {
        this.htmlResource = htmlResource;
        this.config = config;
    }

    public List<Document> get() {
        ArrayList<Document> arrayList;
        block13: {
            InputStream inputStream = this.htmlResource.getInputStream();
            try {
                org.jsoup.nodes.Document doc = Jsoup.parse((InputStream)inputStream, (String)this.config.charset, (String)"");
                ArrayList<Document> documents = new ArrayList<Document>();
                if (this.config.allElements) {
                    String allText = doc.body().text();
                    Document document = new Document(allText);
                    this.addMetadata(doc, document);
                    documents.add(document);
                } else if (this.config.groupByElement) {
                    Elements selectedElements = doc.select(this.config.selector);
                    for (Element element : selectedElements) {
                        String elementText = element.text();
                        Document document = new Document(elementText);
                        this.addMetadata(doc, document);
                        documents.add(document);
                    }
                } else {
                    Elements elements = doc.select(this.config.selector);
                    String text = elements.stream().map(Element::text).collect(Collectors.joining(this.config.separator));
                    Document document = new Document(text);
                    this.addMetadata(doc, document);
                    documents.add(document);
                }
                arrayList = documents;
                if (inputStream == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read HTML resource: " + String.valueOf(this.htmlResource), e);
                }
            }
            inputStream.close();
        }
        return arrayList;
    }

    private void addMetadata(org.jsoup.nodes.Document jsoupDoc, Document springDoc) {
        HashMap<String, Object> metadata = new HashMap<String, Object>();
        metadata.put("title", jsoupDoc.title());
        for (String metaTag : this.config.metadataTags) {
            String value = jsoupDoc.select("meta[name=" + metaTag + "]").attr("content");
            if (value.isEmpty()) continue;
            metadata.put(metaTag, value);
        }
        if (this.config.includeLinkUrls) {
            Elements links = jsoupDoc.select("a[href]");
            List<String> linkUrls = links.stream().map(link -> link.attr("abs:href")).toList();
            metadata.put("linkUrls", linkUrls);
        }
        metadata.putAll(this.config.additionalMetadata);
        springDoc.getMetadata().putAll(metadata);
    }
}

