/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.mcp.client.httpclient.autoconfigure;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.client.transport.customizer.McpAsyncHttpClientRequestCustomizer;
import io.modelcontextprotocol.client.transport.customizer.McpSyncHttpClientRequestCustomizer;
import io.modelcontextprotocol.json.McpJsonMapper;
import io.modelcontextprotocol.json.jackson.JacksonMcpJsonMapper;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.mcp.client.common.autoconfigure.McpSseClientConnectionDetails;
import org.springframework.ai.mcp.client.common.autoconfigure.NamedClientMcpTransport;
import org.springframework.ai.mcp.client.common.autoconfigure.PropertiesMcpSseClientConnectionDetails;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpClientCommonProperties;
import org.springframework.ai.mcp.client.common.autoconfigure.properties.McpSseClientProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.log.LogAccessor;

@AutoConfiguration
@ConditionalOnClass(value={McpSchema.class, McpSyncClient.class})
@EnableConfigurationProperties(value={McpSseClientProperties.class, McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SseHttpClientTransportAutoConfiguration {
    private static final LogAccessor logger = new LogAccessor(SseHttpClientTransportAutoConfiguration.class);

    @Bean
    PropertiesMcpSseClientConnectionDetails mcpSseClientConnectionDetails(McpSseClientProperties sseProperties) {
        return new PropertiesMcpSseClientConnectionDetails(sseProperties);
    }

    @Bean
    public List<NamedClientMcpTransport> sseHttpClientTransports(McpSseClientConnectionDetails connectionDetails, ObjectProvider<ObjectMapper> objectMapperProvider, ObjectProvider<McpSyncHttpClientRequestCustomizer> syncHttpRequestCustomizer, ObjectProvider<McpAsyncHttpClientRequestCustomizer> asyncHttpRequestCustomizer) {
        ObjectMapper objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable(ObjectMapper::new);
        ArrayList<NamedClientMcpTransport> sseTransports = new ArrayList<NamedClientMcpTransport>();
        for (Map.Entry serverParameters : connectionDetails.getConnections().entrySet()) {
            String baseUrl = ((McpSseClientProperties.SseParameters)serverParameters.getValue()).url();
            String sseEndpoint = ((McpSseClientProperties.SseParameters)serverParameters.getValue()).sseEndpoint() != null ? ((McpSseClientProperties.SseParameters)serverParameters.getValue()).sseEndpoint() : "/sse";
            HttpClientSseClientTransport.Builder transportBuilder = HttpClientSseClientTransport.builder((String)baseUrl).sseEndpoint(sseEndpoint).clientBuilder(HttpClient.newBuilder()).jsonMapper((McpJsonMapper)new JacksonMcpJsonMapper(objectMapper));
            asyncHttpRequestCustomizer.ifUnique(arg_0 -> ((HttpClientSseClientTransport.Builder)transportBuilder).asyncHttpRequestCustomizer(arg_0));
            syncHttpRequestCustomizer.ifUnique(arg_0 -> ((HttpClientSseClientTransport.Builder)transportBuilder).httpRequestCustomizer(arg_0));
            if (asyncHttpRequestCustomizer.getIfUnique() != null && syncHttpRequestCustomizer.getIfUnique() != null) {
                logger.warn((CharSequence)"Found beans of type %s and %s. Using %s.".formatted(McpAsyncHttpClientRequestCustomizer.class.getSimpleName(), McpSyncHttpClientRequestCustomizer.class.getSimpleName(), McpSyncHttpClientRequestCustomizer.class.getSimpleName()));
            }
            HttpClientSseClientTransport transport = transportBuilder.build();
            sseTransports.add(new NamedClientMcpTransport((String)serverParameters.getKey(), (McpClientTransport)transport));
        }
        return sseTransports;
    }
}

