/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.net.URI;
import java.util.Map;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpRequest;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected String webJarsPrefixUrl;
    protected UriComponentsBuilder oauthPrefix;

    public SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        super(swaggerUiConfig, springDocConfigProperties, swaggerUiConfigParameters);
        this.webJarsPrefixUrl = springDocConfigProperties.getWebjars().getPrefix();
    }

    protected Mono<Void> redirectToUi(ServerHttpRequest request, ServerHttpResponse response) {
        String contextPath = this.fromCurrentContextPath(request);
        String sbUrl = this.buildUrl(contextPath, this.swaggerUiConfigParameters.getUiRootPath() + this.springDocConfigProperties.getWebjars().getPrefix() + "/swagger-ui/index.html");
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(sbUrl);
        response.setStatusCode(HttpStatus.TEMPORARY_REDIRECT);
        response.getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return response.setComplete();
    }

    protected Map<String, Object> getSwaggerUiConfig(ServerHttpRequest request) {
        this.fromCurrentContextPath(request);
        return this.swaggerUiConfigParameters.getConfigParameters();
    }

    protected void calculateOauth2RedirectUrl(UriComponentsBuilder uriComponentsBuilder) {
        if (this.oauthPrefix == null && !this.swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfigParameters.getOauth2RedirectUrl())) {
            this.oauthPrefix = uriComponentsBuilder.path(this.swaggerUiConfigParameters.getUiRootPath()).path(this.webJarsPrefixUrl);
            this.swaggerUiConfigParameters.setOauth2RedirectUrl(this.oauthPrefix.path(this.swaggerUiConfigParameters.getOauth2RedirectUrl()).build().toString());
        }
    }

    private String fromCurrentContextPath(ServerHttpRequest request) {
        String contextPath = request.getPath().contextPath().value();
        String url = UriComponentsBuilder.fromHttpRequest((HttpRequest)request).toUriString();
        url = url.replace(request.getPath().toString(), "");
        this.buildConfigUrl(contextPath, UriComponentsBuilder.fromUriString((String)url));
        return contextPath;
    }
}

