/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import java.net.URI;
import java.util.Map;
import org.springdoc.core.SwaggerUiConfigProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Controller;
import org.springframework.web.reactive.function.server.RequestPredicate;
import org.springframework.web.reactive.function.server.RequestPredicates;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class SwaggerWelcome {
    @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}")
    private String apiDocsUrl;
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String uiPath;
    @Value(value="${springdoc.webjars.prefix:#{T(org.springdoc.core.Constants).DEFAULT_WEB_JARS_PREFIX_URL}}")
    private String webJarsPrefixUrl;
    @Autowired
    private SwaggerUiConfigProperties swaggerUiConfig;

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    RouterFunction<ServerResponse> routerFunction() {
        String url = this.webJarsPrefixUrl + "/swagger-ui/index.html?url=" + this.apiDocsUrl + "&validatorUrl=";
        Map params = this.swaggerUiConfig.getConfigParameters();
        UriComponentsBuilder builder = params.entrySet().stream().reduce(UriComponentsBuilder.fromUriString((String)url), (b, e) -> b.queryParam((String)e.getKey(), new Object[]{e.getValue()}), (left, right) -> left);
        return RouterFunctions.route((RequestPredicate)RequestPredicates.GET((String)this.uiPath), req -> ServerResponse.temporaryRedirect((URI)URI.create(builder.build().encode().toString())).build());
    }
}

