/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import java.util.List;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerConfigurer;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springdoc.webmvc.ui.SwaggerResourceResolver;
import org.springdoc.webmvc.ui.SwaggerWelcomeCommon;
import org.springframework.boot.autoconfigure.web.WebProperties;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcProperties;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCache;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.CacheControl;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceChainRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.CachingResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;

public class SwaggerWebMvcConfigurer
extends AbstractSwaggerConfigurer
implements WebMvcConfigurer {
    private final SwaggerIndexTransformer swaggerIndexTransformer;
    private final SwaggerResourceResolver swaggerResourceResolver;
    private final SwaggerUiConfigProperties swaggerUiConfigProperties;
    private final WebMvcProperties springWebMvcProperties;
    private final SwaggerWelcomeCommon swaggerWelcomeCommon;
    private Cache cache;

    public SwaggerWebMvcConfigurer(SwaggerUiConfigProperties swaggerUiConfigProperties, WebProperties springWebProperties, WebMvcProperties springWebMvcProperties, SwaggerIndexTransformer swaggerIndexTransformer, SwaggerResourceResolver swaggerResourceResolver, SwaggerWelcomeCommon swaggerWelcomeCommon) {
        super(swaggerUiConfigProperties, springWebProperties);
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.swaggerResourceResolver = swaggerResourceResolver;
        this.swaggerUiConfigProperties = swaggerUiConfigProperties;
        this.springWebMvcProperties = springWebMvcProperties;
        this.swaggerWelcomeCommon = swaggerWelcomeCommon;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        this.addSwaggerResourceHandlers(registry, this.getSwaggerHandlerConfigs());
        this.addSwaggerResourceHandlers(registry, this.getSwaggerWebjarHandlerConfigs());
    }

    protected void addSwaggerResourceHandlers(ResourceHandlerRegistry registry, AbstractSwaggerConfigurer.SwaggerResourceHandlerConfig ... handlerConfigs) {
        for (AbstractSwaggerConfigurer.SwaggerResourceHandlerConfig handlerConfig : handlerConfigs) {
            this.addSwaggerResourceHandler(registry, handlerConfig);
        }
    }

    protected void addSwaggerResourceHandler(ResourceHandlerRegistry registry, AbstractSwaggerConfigurer.SwaggerResourceHandlerConfig handlerConfig) {
        ResourceChainRegistration chainRegistration;
        ResourceHandlerRegistration handlerRegistration = registry.addResourceHandler(handlerConfig.patterns());
        handlerRegistration.addResourceLocations(handlerConfig.locations());
        if (handlerConfig.cacheResources()) {
            chainRegistration = handlerRegistration.resourceChain(true, this.getCache());
        } else {
            handlerRegistration.setUseLastModified(false);
            handlerRegistration.setCacheControl(CacheControl.noStore());
            chainRegistration = handlerRegistration.resourceChain(false);
            chainRegistration.addResolver((ResourceResolver)new CachingResourceResolver(this.getCache()));
        }
        chainRegistration.addResolver((ResourceResolver)this.swaggerResourceResolver);
        chainRegistration.addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }

    protected String getUiRootPath() {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfigProperties);
        this.swaggerWelcomeCommon.calculateUiRootPath(swaggerUiConfigParameters, new StringBuilder[0]);
        return swaggerUiConfigParameters.getUiRootPath();
    }

    protected String getWebjarsPathPattern() {
        return this.springWebMvcProperties.getWebjarsPathPattern();
    }

    protected Cache getCache() {
        if (this.cache == null) {
            this.cache = new ConcurrentMapCache("swagger-resource-chain-cache");
        }
        return this.cache;
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    public void addFormatters(FormatterRegistry registry) {
    }

    public void addInterceptors(InterceptorRegistry registry) {
    }

    public void addCorsMappings(CorsRegistry registry) {
    }

    public void addViewControllers(ViewControllerRegistry registry) {
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    @Nullable
    public Validator getValidator() {
        return null;
    }

    @Nullable
    public MessageCodesResolver getMessageCodesResolver() {
        return null;
    }
}

