/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.ui;

import java.net.URI;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.ui.AbstractSwaggerWelcome;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.ForwardedHeaderUtils;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public abstract class SwaggerWelcomeCommon
extends AbstractSwaggerWelcome {
    protected SwaggerWelcomeCommon(SwaggerUiConfigProperties swaggerUiConfig, SpringDocConfigProperties springDocConfigProperties) {
        super(swaggerUiConfig, springDocConfigProperties);
    }

    protected Mono<Void> redirectToUi(ServerWebExchange exchange) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, exchange);
        String sbUrl = swaggerUiConfigParameters.getContextPath() + swaggerUiConfigParameters.getUiRootPath() + this.getSwaggerUiUrl();
        UriComponentsBuilder uriBuilder = this.getUriComponentsBuilder(swaggerUiConfigParameters, sbUrl);
        exchange.getRequest().getQueryParams().forEach((arg_0, arg_1) -> ((UriComponentsBuilder)uriBuilder).queryParam(arg_0, arg_1));
        exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.FOUND);
        exchange.getResponse().getHeaders().setLocation(URI.create(uriBuilder.build().encode().toString()));
        return exchange.getResponse().setComplete();
    }

    protected void calculateOauth2RedirectUrl(SwaggerUiConfigParameters swaggerUiConfigParameters, UriComponentsBuilder uriComponentsBuilder) {
        if (StringUtils.isBlank((CharSequence)this.swaggerUiConfig.getOauth2RedirectUrl()) || !swaggerUiConfigParameters.isValidUrl(this.swaggerUiConfig.getOauth2RedirectUrl())) {
            swaggerUiConfigParameters.setOauth2RedirectUrl(uriComponentsBuilder.path(swaggerUiConfigParameters.getUiRootPath()).path(this.getOauth2RedirectUrl()).build().toString());
        }
    }

    protected abstract void calculateUiRootPath(SwaggerUiConfigParameters var1, StringBuilder ... var2);

    protected Map<String, Object> getSwaggerUiConfig(ServerWebExchange exchange) {
        SwaggerUiConfigParameters swaggerUiConfigParameters = new SwaggerUiConfigParameters(this.swaggerUiConfig);
        this.buildFromCurrentContextPath(swaggerUiConfigParameters, exchange);
        return swaggerUiConfigParameters.getConfigParameters();
    }

    protected void buildFromCurrentContextPath(SwaggerUiConfigParameters swaggerUiConfigParameters, ServerWebExchange exchange) {
        super.init(swaggerUiConfigParameters);
        String contextPath = exchange.getRequest().getPath().contextPath().value();
        swaggerUiConfigParameters.setContextPath(contextPath);
        URI uri = exchange.getRequest().getURI();
        HttpHeaders headers = exchange.getRequest().getHeaders();
        UriComponentsBuilder uriComponentsBuilder = ForwardedHeaderUtils.adaptFromForwardedHeaders((URI)uri, (HttpHeaders)headers).replacePath(contextPath).replaceQuery(null).fragment(null);
        this.buildConfigUrl(swaggerUiConfigParameters, uriComponentsBuilder);
    }
}

