/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.scalar;

import com.scalar.maven.webjar.ScalarProperties;
import java.io.IOException;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.scalar.AbstractScalarController;
import org.springframework.http.ResponseEntity;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import tools.jackson.databind.ObjectMapper;

@Controller
@RequestMapping(value={"${scalar.path:/scalar}"})
public class ScalarWebFluxController
extends AbstractScalarController {
    private final SpringDocConfigProperties springDocConfigProperties;

    protected ScalarWebFluxController(ScalarProperties scalarProperties, SpringDocConfigProperties springDocConfigProperties, ObjectMapper objectMapper) {
        super(scalarProperties, objectMapper);
        this.springDocConfigProperties = springDocConfigProperties;
    }

    @GetMapping
    public ResponseEntity<String> getDocs(ServerHttpRequest serverHttpRequest) throws IOException {
        return super.getDocs(serverHttpRequest.getURI().toString());
    }

    @GetMapping(value={"/scalar.js", "scalar.js"})
    public ResponseEntity<byte[]> getScalarJs() throws IOException {
        return super.getScalarJs();
    }

    public String buildApiDocsUrl(String requestUrl) {
        String apiDocsPath = this.springDocConfigProperties.getApiDocs().getPath();
        return this.buildApiDocsUrl(requestUrl, apiDocsPath);
    }

    public String buildJsBundleUrl(String requestUrl) {
        String scalarPath = this.scalarProperties.getPath();
        return this.buildJsBundleUrl(requestUrl, scalarPath);
    }
}

