/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.scalar;

import com.scalar.maven.core.ScalarHtmlRenderer;
import com.scalar.maven.core.ScalarProperties;
import com.scalar.maven.core.config.ScalarSource;
import io.swagger.v3.oas.annotations.Operation;
import java.io.IOException;
import java.util.List;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;

public abstract class AbstractScalarController {
    protected final SpringDocConfigProperties springDocConfigProperties;
    protected final ScalarProperties scalarProperties;
    protected final String originalScalarUrl;

    protected AbstractScalarController(ScalarProperties scalarProperties, SpringDocConfigProperties springDocConfigProperties) {
        this.springDocConfigProperties = springDocConfigProperties;
        this.scalarProperties = scalarProperties;
        this.originalScalarUrl = scalarProperties.getUrl();
    }

    @GetMapping(value={"/scalar.js", "scalar.js"})
    @Operation(hidden=true)
    public ResponseEntity<byte[]> getScalarJs() throws IOException {
        byte[] jsContent = ScalarHtmlRenderer.getScalarJsContent();
        return ResponseEntity.ok().contentType(MediaType.valueOf((String)"application/javascript")).body((Object)jsContent);
    }

    protected ResponseEntity<String> getDocs(String requestUrl, String apiDocsPath, String scalarPath) throws IOException {
        ScalarProperties configuredProperties = this.configureProperties(this.scalarProperties, requestUrl, apiDocsPath);
        String url = configuredProperties.getUrl();
        List<ScalarSource> scalarSources = this.springDocConfigProperties.getGroupConfigs().stream().map(groupConfig -> new ScalarSource(url + "/" + groupConfig.getGroup(), groupConfig.getDisplayName(), null, Boolean.valueOf(false))).toList();
        if (!CollectionUtils.isEmpty(scalarSources)) {
            this.scalarProperties.setSources(scalarSources);
            this.scalarProperties.setUrl(null);
        }
        String html = ScalarHtmlRenderer.render((ScalarProperties)configuredProperties);
        String bundleUrl = this.buildJsBundleUrl(requestUrl, scalarPath);
        html = html.replaceAll("(<script[^>]*\\s+src\\s*=\\s*\")([^\"]*)(\")", "$1" + bundleUrl + "$3");
        return ResponseEntity.ok().contentType(MediaType.TEXT_HTML).body((Object)html);
    }

    private ScalarProperties configureProperties(ScalarProperties properties, String requestUrl, String apiDocsPath) {
        String url = this.buildApiDocsUrl(requestUrl, apiDocsPath);
        properties.setUrl(url);
        return properties;
    }

    private String buildJsBundleUrl(String requestUrl, String scalarPath) {
        if ("https://registry.scalar.com/@scalar/apis/galaxy?format=json".equals(this.originalScalarUrl) && requestUrl.contains("://")) {
            String path;
            int firstPathSlash = requestUrl.indexOf(47, requestUrl.indexOf("://") + 3);
            String string = path = firstPathSlash >= 0 ? requestUrl.substring(firstPathSlash) : "/";
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            return path + "/scalar.js";
        }
        return scalarPath + "/scalar.js";
    }

    private String buildApiDocsUrl(String requestUrl, String apiDocsPath) {
        Object apiDocsUrl = this.scalarProperties.getUrl();
        if ("https://registry.scalar.com/@scalar/apis/galaxy?format=json".equals(this.originalScalarUrl)) {
            String serverUrl = requestUrl.substring(0, requestUrl.length() - this.scalarProperties.getPath().length());
            apiDocsUrl = serverUrl + apiDocsPath;
        }
        return apiDocsUrl;
    }
}

