/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.util.Json;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.properties.SwaggerUiConfigParameters;
import org.springdoc.core.properties.SwaggerUiConfigProperties;
import org.springdoc.core.properties.SwaggerUiOAuthProperties;
import org.springframework.util.CollectionUtils;

public class AbstractSwaggerIndexTransformer {
    private static final String PRESETS = "presets: [";
    protected SwaggerUiOAuthProperties swaggerUiOAuthProperties;
    protected SwaggerUiConfigParameters swaggerUiConfigParameters;
    protected ObjectMapper objectMapper;
    protected SwaggerUiConfigProperties swaggerUiConfig;

    public AbstractSwaggerIndexTransformer(SwaggerUiConfigProperties swaggerUiConfig, SwaggerUiOAuthProperties swaggerUiOAuthProperties, SwaggerUiConfigParameters swaggerUiConfigParameters) {
        this.swaggerUiConfig = swaggerUiConfig;
        this.swaggerUiOAuthProperties = swaggerUiOAuthProperties;
        this.swaggerUiConfigParameters = swaggerUiConfigParameters;
        this.objectMapper = Json.mapper();
    }

    protected String addInitOauth(String html) throws JsonProcessingException {
        StringBuilder stringBuilder = new StringBuilder("window.ui = ui\n");
        stringBuilder.append("ui.initOAuth(\n");
        String json = this.objectMapper.writeValueAsString(this.swaggerUiOAuthProperties.getConfigParameters());
        stringBuilder.append(json);
        stringBuilder.append(")");
        return html.replace("window.ui = ui", stringBuilder.toString());
    }

    protected String readFullyAsString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toString(StandardCharsets.UTF_8.name());
    }

    protected String overwriteSwaggerDefaultUrl(String html) {
        return html.replace("https://petstore.swagger.io/v2/swagger.json", "");
    }

    protected String defaultTransformations(InputStream inputStream) throws IOException {
        String html = this.readFullyAsString(inputStream);
        if (!CollectionUtils.isEmpty(this.swaggerUiOAuthProperties.getConfigParameters())) {
            html = this.addInitOauth(html);
        }
        if (this.swaggerUiConfig.isCsrfEnabled()) {
            html = this.swaggerUiConfig.getCsrf().isUseLocalStorage() ? this.addCSRFLocalStorage(html) : this.addCSRF(html);
        }
        if (this.swaggerUiConfig.getSyntaxHighlight().isPresent()) {
            html = this.addSyntaxHighlight(html);
        }
        html = this.swaggerUiConfig.getQueryConfigEnabled() == null || this.swaggerUiConfig.getQueryConfigEnabled() == false ? this.addParameters(html) : this.addParameter(html, "queryConfigEnabled", this.swaggerUiConfig.getQueryConfigEnabled().toString());
        if (this.swaggerUiConfig.isDisableSwaggerDefaultUrl()) {
            html = this.overwriteSwaggerDefaultUrl(html);
        }
        return html;
    }

    protected String addParameters(String html) throws JsonProcessingException {
        String layout = this.swaggerUiConfigParameters.getLayout() != null ? this.swaggerUiConfigParameters.getLayout() : "StandaloneLayout";
        StringBuilder stringBuilder = new StringBuilder("layout: \"" + layout + "\" ,\n");
        Map parametersObjectMap = this.swaggerUiConfigParameters.getConfigParameters().entrySet().stream().filter(entry -> !"oauth2RedirectUrl".equals(entry.getKey())).filter(entry -> !"url".equals(entry.getKey())).filter(entry -> !"urls".equals(entry.getKey())).filter(entry -> "validatorUrl".equals(entry.getKey()) || StringUtils.isNotEmpty((CharSequence)((String)entry.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e2, LinkedHashMap::new));
        if (!CollectionUtils.isEmpty((Map)parametersObjectMap)) {
            String result = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)parametersObjectMap);
            result = result.substring(1, result.length() - 1);
            stringBuilder.append(result);
            html = html.replace("layout: \"StandaloneLayout\"", stringBuilder.toString());
        }
        return html;
    }

    private String addParameter(String html, String key, String value) {
        StringBuilder stringBuilder = new StringBuilder("const ui = SwaggerUIBundle({\n");
        stringBuilder.append(key + ": \"" + value + "\",");
        return html.replace("const ui = SwaggerUIBundle({", stringBuilder.toString());
    }

    protected String addCSRF(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("requestInterceptor: (request) => {\n");
        stringBuilder.append("\t\t\tconst value = `; ${document.cookie}`;\n");
        stringBuilder.append("\t\t\tconst parts = value.split(`; ");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getCookieName());
        stringBuilder.append("=`);\n");
        stringBuilder.append("\t\t\tconst currentURL = new URL(document.URL);\n");
        stringBuilder.append("\t\t\tconst requestURL = new URL(request.url, document.location.origin);\n");
        stringBuilder.append("\t\t\tconst isSameOrigin = (currentURL.protocol === requestURL.protocol && currentURL.host === requestURL.host);\n");
        stringBuilder.append("\t\t\tif (isSameOrigin && parts.length === 2) ");
        stringBuilder.append("request.headers['");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getHeaderName());
        stringBuilder.append("'] = parts.pop().split(';').shift();\n");
        stringBuilder.append("\t\t\treturn request;\n");
        stringBuilder.append("\t\t},\n");
        stringBuilder.append("\t\tpresets: [");
        return html.replace(PRESETS, stringBuilder.toString());
    }

    protected String addCSRFLocalStorage(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("requestInterceptor: (request) => {\n");
        stringBuilder.append("t\t\tconst value = window.localStorage.getItem('");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getLocalStorageKey() + "');\n");
        stringBuilder.append("t\t\tconst currentURL = new URL(document.URL);\n");
        stringBuilder.append("t\t\tconst requestURL = new URL(request.url, document.location.origin);\n");
        stringBuilder.append("t\t\tconst isSameOrigin = (currentURL.protocol === requestURL.protocol && currentURL.host === requestURL.host);\n");
        stringBuilder.append("t\t\tif (isSameOrigin) ");
        stringBuilder.append("request.headers['");
        stringBuilder.append(this.swaggerUiConfig.getCsrf().getHeaderName());
        stringBuilder.append("'] = value;\n");
        stringBuilder.append("t\t\treturn request;\n");
        stringBuilder.append("\t\t},\n");
        stringBuilder.append("\t\tpresets: [");
        return html.replace(PRESETS, stringBuilder.toString());
    }

    protected String addSyntaxHighlight(String html) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("syntaxHighlight: {");
        if (this.swaggerUiConfig.getSyntaxHighlight().getActivated() != null) {
            stringBuilder.append("activated: ");
            stringBuilder.append(this.swaggerUiConfig.getSyntaxHighlight().getActivated());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.swaggerUiConfig.getSyntaxHighlight().getTheme())) {
            if (this.swaggerUiConfig.getSyntaxHighlight().getActivated() != null) {
                stringBuilder.append(" , ");
            }
            stringBuilder.append("theme: \"");
            stringBuilder.append(this.swaggerUiConfig.getSyntaxHighlight().getTheme());
            stringBuilder.append("\"");
        }
        stringBuilder.append("},\n");
        stringBuilder.append(PRESETS);
        return html.replace(PRESETS, stringBuilder.toString());
    }
}

