/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="generate", requiresProject=true, defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class SpringDocMojo
extends AbstractMojo {
    private static final String DEFAULT_OUTPUT_FILE_NAME = "openapi";
    private static final String DEFAULT_OUTPUT_EXTENSION = ".json";
    private static final String DEFAULT_OUTPUT_FILE = "openapi.json";
    @Parameter(defaultValue="http://localhost:8080/v3/api-docs", property="springdoc.apiDocsUrl", required=true)
    private String apiDocsUrl;
    @Parameter(defaultValue="openapi.json", property="springdoc.outputFileName", required=true)
    private String outputFileName;
    @Parameter(defaultValue="${project.build.directory}", property="springdoc.outputDir", required=true)
    private File outputDir;
    @Parameter(defaultValue="false", property="springdoc.attachArtifact")
    private boolean attachArtifact;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false", property="springdoc.skip")
    private boolean skip;
    @Component
    private MavenProjectHelper projectHelper;
    private static final String GET = "GET";

    public void execute() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip execution as per configuration");
            return;
        }
        try {
            URL urlForGetRequest = new URL(this.apiDocsUrl);
            HttpURLConnection conection = (HttpURLConnection)urlForGetRequest.openConnection();
            conection.setRequestMethod(GET);
            int responseCode = conection.getResponseCode();
            if (responseCode == 200) {
                String result = this.readFullyAsString(conection.getInputStream());
                this.outputDir.mkdirs();
                Files.write(Paths.get(this.outputDir.getAbsolutePath() + "/" + this.outputFileName, new String[0]), result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                if (this.attachArtifact) {
                    this.addArtifactToMaven();
                }
            } else {
                this.getLog().error((CharSequence)("An error has occured: Response code " + responseCode));
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"An error has occured", (Throwable)e);
        }
    }

    private String readFullyAsString(InputStream inputStream) throws IOException {
        return this.readFully(inputStream).toString(StandardCharsets.UTF_8.name());
    }

    private ByteArrayOutputStream readFully(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos;
    }

    private void addArtifactToMaven() {
        File swaggerFile = new File(this.outputDir.getAbsolutePath() + '/' + this.outputFileName);
        String extension = this.getFileExtension();
        this.projectHelper.attachArtifact(this.project, extension, DEFAULT_OUTPUT_FILE_NAME, swaggerFile);
    }

    private String getFileExtension() {
        String extension = DEFAULT_OUTPUT_EXTENSION;
        int i = this.outputFileName.lastIndexOf(46);
        if (i > 0) {
            extension = this.outputFileName.substring(i + 1);
        }
        return extension;
    }
}

