/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.headers.Header;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springdoc.core.SpringDocConfigProperties;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;

public class GenericResponseBuilder {
    private final Map<String, ApiResponse> genericMapResponse = new LinkedHashMap<String, ApiResponse>();
    private final OperationBuilder operationBuilder;
    private final List<ReturnTypeParser> returnTypeParsers;
    private final SpringDocConfigProperties springDocConfigProperties;
    private final PropertyResolverUtils propertyResolverUtils;

    public GenericResponseBuilder(OperationBuilder operationBuilder, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        this.operationBuilder = operationBuilder;
        this.returnTypeParsers = returnTypeParsers;
        this.springDocConfigProperties = springDocConfigProperties;
        this.propertyResolverUtils = propertyResolverUtils;
    }

    public io.swagger.v3.oas.models.responses.ApiResponses build(Components components, HandlerMethod handlerMethod, Operation operation, MethodAttributes methodAttributes) {
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = new io.swagger.v3.oas.models.responses.ApiResponses();
        this.genericMapResponse.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.responses.ApiResponses)apiResponses).addApiResponse(arg_0, arg_1));
        io.swagger.v3.oas.models.responses.ApiResponses apiResponsesFromDoc = operation.getResponses();
        if (!CollectionUtils.isEmpty((Map)apiResponsesFromDoc)) {
            apiResponsesFromDoc.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.responses.ApiResponses)apiResponses).addApiResponse(arg_0, arg_1));
        }
        this.computeResponse(components, handlerMethod.getReturnType(), apiResponses, methodAttributes, false);
        return apiResponses;
    }

    public void buildGenericResponse(Components components, Map<String, Object> findControllerAdvice) {
        List<Method> methods = this.getMethods(findControllerAdvice);
        for (Method method : methods) {
            if (this.operationBuilder.isHidden(method)) continue;
            RequestMapping reqMappringMethod = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
            String[] methodProduces = new String[]{this.springDocConfigProperties.getDefaultProducesMediaType()};
            if (reqMappringMethod != null) {
                methodProduces = reqMappringMethod.produces();
            }
            Map<String, ApiResponse> apiResponses = this.computeResponse(components, new MethodParameter(method, -1), new io.swagger.v3.oas.models.responses.ApiResponses(), new MethodAttributes(methodProduces, this.springDocConfigProperties.getDefaultConsumesMediaType(), this.springDocConfigProperties.getDefaultProducesMediaType()), true);
            apiResponses.forEach(this.genericMapResponse::put);
        }
    }

    private List<Method> getMethods(Map<String, Object> findControllerAdvice) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map.Entry<String, Object> entry : findControllerAdvice.entrySet()) {
            Object controllerAdvice = entry.getValue();
            Class objClz = controllerAdvice.getClass();
            if (AopUtils.isAopProxy((Object)controllerAdvice)) {
                objClz = AopUtils.getTargetClass((Object)controllerAdvice);
            }
            Arrays.stream(objClz.getDeclaredMethods()).filter(m -> m.isAnnotationPresent(ExceptionHandler.class)).forEach(methods::add);
        }
        return methods;
    }

    private Map<String, ApiResponse> computeResponse(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, boolean isGeneric) {
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responsesArray = this.getApiResponses(methodParameter.getMethod());
        if (!responsesArray.isEmpty()) {
            methodAttributes.setWithApiResponseDoc(true);
            if (!this.springDocConfigProperties.isOverrideWithGenericResponse()) {
                for (String key : this.genericMapResponse.keySet()) {
                    apiResponsesOp.remove((Object)key);
                }
            }
            for (io.swagger.v3.oas.annotations.responses.ApiResponse apiResponseAnnotations : responsesArray) {
                ApiResponse apiResponse = new ApiResponse();
                if (StringUtils.isNotBlank((CharSequence)apiResponseAnnotations.ref())) {
                    apiResponse.$ref(apiResponseAnnotations.ref());
                    apiResponsesOp.addApiResponse(apiResponseAnnotations.responseCode(), apiResponse);
                    continue;
                }
                apiResponse.setDescription(this.propertyResolverUtils.resolve(apiResponseAnnotations.description()));
                io.swagger.v3.oas.annotations.media.Content[] contentdoc = apiResponseAnnotations.content();
                this.buildContentFromDoc(components, apiResponsesOp, methodAttributes, apiResponseAnnotations, apiResponse, contentdoc);
                Map extensions = AnnotationsUtils.getExtensions((Extension[])apiResponseAnnotations.extensions());
                if (!CollectionUtils.isEmpty((Map)extensions)) {
                    apiResponse.extensions(extensions);
                }
                AnnotationsUtils.getHeaders((Header[])apiResponseAnnotations.headers(), (JsonView)methodAttributes.getJsonViewAnnotation()).ifPresent(arg_0 -> ((ApiResponse)apiResponse).headers(arg_0));
                apiResponsesOp.addApiResponse(apiResponseAnnotations.responseCode(), apiResponse);
            }
        }
        this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, isGeneric);
        return apiResponsesOp;
    }

    private void buildContentFromDoc(Components components, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, io.swagger.v3.oas.annotations.responses.ApiResponse apiResponseAnnotations, ApiResponse apiResponse, io.swagger.v3.oas.annotations.media.Content[] contentdoc) {
        Optional<Content> optionalContent = SpringDocAnnotationsUtils.getContent(contentdoc, new String[0], methodAttributes.getMethodProduces(), null, components, methodAttributes.getJsonViewAnnotation());
        if (apiResponsesOp.containsKey((Object)apiResponseAnnotations.responseCode())) {
            Content existingContent = ((ApiResponse)apiResponsesOp.get((Object)apiResponseAnnotations.responseCode())).getContent();
            if (optionalContent.isPresent() && existingContent != null) {
                Content newContent = optionalContent.get();
                if (methodAttributes.isMethodOverloaded()) {
                    Arrays.stream(methodAttributes.getMethodProduces()).filter(mediaTypeStr -> newContent.get(mediaTypeStr) != null).forEach(mediaTypeStr -> this.mergeSchema(existingContent, (Schema<?>)((MediaType)newContent.get(mediaTypeStr)).getSchema(), (String)mediaTypeStr));
                    apiResponse.content(existingContent);
                } else {
                    apiResponse.content(newContent);
                }
            }
        } else {
            optionalContent.ifPresent(arg_0 -> ((ApiResponse)apiResponse).content(arg_0));
        }
    }

    private void buildApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, boolean isGeneric) {
        if (!CollectionUtils.isEmpty((Map)apiResponsesOp) && (apiResponsesOp.size() != this.genericMapResponse.size() || isGeneric)) {
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                String httpCode = (String)entry.getKey();
                ApiResponse apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, apiResponse, isGeneric);
            }
        } else {
            ApiResponse apiResponse;
            String httpCode = this.evaluateResponseStatus(methodParameter.getMethod(), methodParameter.getMethod().getClass(), isGeneric);
            ApiResponse apiResponse2 = apiResponse = this.genericMapResponse.containsKey(httpCode) ? this.genericMapResponse.get(httpCode) : new ApiResponse();
            if (httpCode != null) {
                this.buildApiResponses(components, methodParameter, apiResponsesOp, methodAttributes, httpCode, apiResponse, isGeneric);
            }
        }
    }

    private Set<io.swagger.v3.oas.annotations.responses.ApiResponse> getApiResponses(Method method) {
        Class<?> declaringClass = method.getDeclaringClass();
        Set apiResponsesDoc = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, ApiResponses.class);
        Set<io.swagger.v3.oas.annotations.responses.ApiResponse> responses = apiResponsesDoc.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet());
        Set apiResponsesDocDeclaringClass = AnnotatedElementUtils.findAllMergedAnnotations(declaringClass, ApiResponses.class);
        responses.addAll(apiResponsesDocDeclaringClass.stream().flatMap(x -> Stream.of(x.value())).collect(Collectors.toSet()));
        Set apiResponseDoc = AnnotatedElementUtils.findMergedRepeatableAnnotations((AnnotatedElement)method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        responses.addAll(apiResponseDoc);
        Set apiResponseDocDeclaringClass = AnnotatedElementUtils.findMergedRepeatableAnnotations(declaringClass, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        responses.addAll(apiResponseDocDeclaringClass);
        return responses;
    }

    private Content buildContent(Components components, MethodParameter methodParameter, String[] methodProduces, JsonView jsonView) {
        Schema schemaN;
        Content content = new Content();
        Type returnType = this.getReturnType(methodParameter);
        if (this.isVoid(returnType)) {
            return null;
        }
        if (ArrayUtils.isNotEmpty((Object[])methodProduces) && (schemaN = this.calculateSchema(components, returnType, jsonView)) != null) {
            MediaType mediaType = new MediaType();
            mediaType.setSchema(schemaN);
            this.setContent(methodProduces, content, mediaType);
        }
        return content;
    }

    private Type getReturnType(MethodParameter methodParameter) {
        Object returnType = Object.class;
        for (ReturnTypeParser returnTypeParser : this.returnTypeParsers) {
            if (!returnType.getTypeName().equals(Object.class.getTypeName())) break;
            returnType = returnTypeParser.getReturnType(methodParameter);
        }
        return returnType;
    }

    public Schema calculateSchema(Components components, Type returnType, JsonView jsonView) {
        return !this.isVoid(returnType) ? SpringDocAnnotationsUtils.extractSchema(components, returnType, jsonView) : null;
    }

    private void setContent(String[] methodProduces, Content content, MediaType mediaType) {
        Arrays.stream(methodProduces).forEach(mediaTypeStr -> content.addMediaType(mediaTypeStr, mediaType));
    }

    private void buildApiResponses(Components components, MethodParameter methodParameter, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, MethodAttributes methodAttributes, String httpCode, ApiResponse apiResponse, boolean isGeneric) {
        if (StringUtils.isBlank((CharSequence)apiResponse.get$ref())) {
            if (apiResponse.getContent() == null) {
                Content content = this.buildContent(components, methodParameter, methodAttributes.getMethodProduces(), methodAttributes.getJsonViewAnnotation());
                apiResponse.setContent(content);
            } else if (CollectionUtils.isEmpty((Map)apiResponse.getContent())) {
                apiResponse.setContent(null);
            }
            if (StringUtils.isBlank((CharSequence)apiResponse.getDescription())) {
                apiResponse.setDescription("default response");
            }
        }
        if (apiResponse.getContent() != null && (isGeneric || methodAttributes.isMethodOverloaded()) && methodAttributes.isNoApiResponseDoc()) {
            Content existingContent = apiResponse.getContent();
            Schema schemaN = this.calculateSchema(components, methodParameter.getGenericParameterType(), methodAttributes.getJsonViewAnnotation());
            if (schemaN != null && ArrayUtils.isNotEmpty((Object[])methodAttributes.getMethodProduces())) {
                Arrays.stream(methodAttributes.getMethodProduces()).forEach(mediaTypeStr -> this.mergeSchema(existingContent, (Schema<?>)schemaN, (String)mediaTypeStr));
            }
        }
        apiResponsesOp.addApiResponse(httpCode, apiResponse);
    }

    private void mergeSchema(Content existingContent, Schema<?> schemaN, String mediaTypeStr) {
        if (existingContent.containsKey((Object)mediaTypeStr)) {
            MediaType mediaType = (MediaType)existingContent.get((Object)mediaTypeStr);
            if (!schemaN.equals((Object)mediaType.getSchema())) {
                ComposedSchema schemaObject;
                Schema firstSchema = mediaType.getSchema();
                if (firstSchema instanceof ComposedSchema) {
                    schemaObject = (ComposedSchema)firstSchema;
                    List listOneOf = schemaObject.getOneOf();
                    if (!CollectionUtils.isEmpty((Collection)listOneOf) && !listOneOf.contains(schemaN)) {
                        schemaObject.addOneOfItem(schemaN);
                    }
                } else {
                    schemaObject = new ComposedSchema();
                    schemaObject.addOneOfItem(schemaN);
                    schemaObject.addOneOfItem(firstSchema);
                }
                mediaType.setSchema((Schema)schemaObject);
                existingContent.addMediaType(mediaTypeStr, mediaType);
            }
        } else {
            existingContent.addMediaType(mediaTypeStr, new MediaType().schema(schemaN));
        }
    }

    private String evaluateResponseStatus(Method method, Class<?> beanType, boolean isGeneric) {
        String responseStatus = null;
        ResponseStatus annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ResponseStatus.class);
        if (annotation == null && beanType != null) {
            annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(beanType, ResponseStatus.class);
        }
        if (annotation != null) {
            responseStatus = String.valueOf(annotation.code().value());
        }
        if (annotation == null && !isGeneric) {
            responseStatus = String.valueOf(HttpStatus.OK.value());
        }
        return responseStatus;
    }

    private boolean isVoid(Type returnType) {
        Type[] types;
        boolean result = false;
        if (Void.TYPE.equals(returnType)) {
            result = true;
        } else if (returnType instanceof ParameterizedType && (types = ((ParameterizedType)returnType).getActualTypeArguments()) != null) {
            return this.isVoid(types[0]);
        }
        if (Void.class.equals((Object)returnType)) {
            result = true;
        }
        return result;
    }
}

