/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.Explode;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.springdoc.core.RequestBodyInfo;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractParameterBuilder {
    private final LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer;

    protected AbstractParameterBuilder(LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        this.localSpringDocParameterNameDiscoverer = localSpringDocParameterNameDiscoverer;
    }

    public LocalVariableTableParameterNameDiscoverer getLocalSpringDocParameterNameDiscoverer() {
        return this.localSpringDocParameterNameDiscoverer;
    }

    io.swagger.v3.oas.models.parameters.Parameter mergeParameter(List<io.swagger.v3.oas.models.parameters.Parameter> existingParamDoc, io.swagger.v3.oas.models.parameters.Parameter paramCalcul) {
        io.swagger.v3.oas.models.parameters.Parameter result = paramCalcul;
        if (paramCalcul != null && paramCalcul.getName() != null) {
            String name = paramCalcul.getName();
            io.swagger.v3.oas.models.parameters.Parameter paramDoc = existingParamDoc.stream().filter(p -> name.equals(p.getName())).findAny().orElse(null);
            if (paramDoc != null) {
                this.mergeParameter(paramCalcul, paramDoc);
                result = paramDoc;
            } else {
                existingParamDoc.add(result);
            }
        }
        return result;
    }

    private void mergeParameter(io.swagger.v3.oas.models.parameters.Parameter paramCalcul, io.swagger.v3.oas.models.parameters.Parameter paramDoc) {
        if (StringUtils.isBlank((CharSequence)paramDoc.getDescription())) {
            paramDoc.setDescription(paramCalcul.getDescription());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.getIn())) {
            paramDoc.setIn(paramCalcul.getIn());
        }
        if (paramDoc.getExample() == null) {
            paramDoc.setExample(paramCalcul.getExample());
        }
        if (paramDoc.getDeprecated() == null) {
            paramDoc.setDeprecated(paramCalcul.getDeprecated());
        }
        if (paramDoc.getRequired() == null) {
            paramDoc.setRequired(paramCalcul.getRequired());
        }
        if (paramDoc.getAllowEmptyValue() == null) {
            paramDoc.setAllowEmptyValue(paramCalcul.getAllowEmptyValue());
        }
        if (paramDoc.getAllowReserved() == null) {
            paramDoc.setAllowReserved(paramCalcul.getAllowReserved());
        }
        if (StringUtils.isBlank((CharSequence)paramDoc.get$ref())) {
            paramDoc.set$ref(paramDoc.get$ref());
        }
        if (paramDoc.getSchema() == null) {
            paramDoc.setSchema(paramCalcul.getSchema());
        }
        if (paramDoc.getExamples() == null) {
            paramDoc.setExamples(paramCalcul.getExamples());
        }
        if (paramDoc.getExtensions() == null) {
            paramDoc.setExtensions(paramCalcul.getExtensions());
        }
        if (paramDoc.getStyle() == null) {
            paramDoc.setStyle(paramCalcul.getStyle());
        }
        if (paramDoc.getExplode() == null) {
            paramDoc.setExplode(paramCalcul.getExplode());
        }
    }

    io.swagger.v3.oas.models.parameters.Parameter buildParameterFromDoc(Parameter parameterDoc, Components components, JsonView jsonView) {
        io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.description())) {
            parameter.setDescription(parameterDoc.description());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.name())) {
            parameter.setName(parameterDoc.name());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.in().toString())) {
            parameter.setIn(parameterDoc.in().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.example())) {
            try {
                parameter.setExample((Object)Json.mapper().readTree(parameterDoc.example()));
            }
            catch (IOException e) {
                parameter.setExample((Object)parameterDoc.example());
            }
        }
        if (parameterDoc.deprecated()) {
            parameter.setDeprecated(Boolean.valueOf(parameterDoc.deprecated()));
        }
        if (parameterDoc.required()) {
            parameter.setRequired(Boolean.valueOf(parameterDoc.required()));
        }
        if (parameterDoc.allowEmptyValue()) {
            parameter.setAllowEmptyValue(Boolean.valueOf(parameterDoc.allowEmptyValue()));
        }
        if (parameterDoc.allowReserved()) {
            parameter.setAllowReserved(Boolean.valueOf(parameterDoc.allowReserved()));
        }
        if (StringUtils.isNotBlank((CharSequence)parameterDoc.ref())) {
            parameter.$ref(parameterDoc.ref());
        } else {
            io.swagger.v3.oas.models.media.Schema schema = AnnotationsUtils.getSchemaFromAnnotation((Schema)parameterDoc.schema(), (Components)components, (JsonView)jsonView).orElse(null);
            parameter.setSchema(schema);
        }
        this.setExamples(parameterDoc, parameter);
        this.setExtensions(parameterDoc, parameter);
        this.setParameterStyle(parameter, parameterDoc);
        this.setParameterExplode(parameter, parameterDoc);
        return parameter;
    }

    io.swagger.v3.oas.models.media.Schema calculateSchema(Components components, java.lang.reflect.Parameter parameter, String paramName, RequestBodyInfo requestBodyInfo, JsonView jsonView) {
        io.swagger.v3.oas.models.media.Schema schemaN;
        Class<?> schemaImplementation = null;
        Type returnType = null;
        JavaType ct = null;
        if (parameter != null) {
            returnType = parameter.getParameterizedType();
            ct = this.constructType(parameter.getType());
            schemaImplementation = parameter.getType();
        }
        if (this.isFile(ct)) {
            io.swagger.v3.oas.models.media.Schema schemaN2 = this.getFileSchema(requestBodyInfo);
            schemaN2.addProperties(paramName, (io.swagger.v3.oas.models.media.Schema)new FileSchema());
            return schemaN2;
        }
        if (returnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)returnType;
            if (this.isFile(parameterizedType)) {
                return this.extractFileSchema(paramName, requestBodyInfo);
            }
            schemaN = this.calculateSchemaFromParameterizedType(components, returnType, jsonView);
        } else {
            schemaN = SpringDocAnnotationsUtils.resolveSchemaFromType(schemaImplementation, components, jsonView);
        }
        if (this.isRequestBodySchema(requestBodyInfo)) {
            requestBodyInfo.getMergedSchema().addProperties(paramName, schemaN);
            schemaN = requestBodyInfo.getMergedSchema();
        }
        return schemaN;
    }

    protected abstract io.swagger.v3.oas.models.media.Schema calculateSchemaFromParameterizedType(Components var1, Type var2, JsonView var3);

    private io.swagger.v3.oas.models.media.Schema extractFileSchema(String paramName, RequestBodyInfo requestBodyInfo) {
        io.swagger.v3.oas.models.media.Schema schemaN = this.getFileSchema(requestBodyInfo);
        ArraySchema schemafile = new ArraySchema();
        schemafile.items((io.swagger.v3.oas.models.media.Schema)new FileSchema());
        schemaN.addProperties(paramName, (io.swagger.v3.oas.models.media.Schema)new ArraySchema().items((io.swagger.v3.oas.models.media.Schema)new FileSchema()));
        return schemaN;
    }

    private io.swagger.v3.oas.models.media.Schema getFileSchema(RequestBodyInfo requestBodyInfo) {
        Object schemaN = this.isRequestBodySchema(requestBodyInfo) ? requestBodyInfo.getMergedSchema() : new ObjectSchema();
        return schemaN;
    }

    private boolean isRequestBodySchema(RequestBodyInfo requestBodyInfo) {
        return requestBodyInfo != null && requestBodyInfo.getMergedSchema() != null;
    }

    protected abstract boolean isFile(ParameterizedType var1);

    protected abstract boolean isFile(JavaType var1);

    <A extends Annotation> A getParameterAnnotation(HandlerMethod handlerMethod, java.lang.reflect.Parameter parameter, int i, Class<A> annotationType) {
        Annotation parameterDoc;
        block1: {
            Method methodOverriden;
            parameterDoc = AnnotationUtils.getAnnotation((AnnotatedElement)parameter, annotationType);
            if (parameterDoc != null) break block1;
            Set methods = MethodUtils.getOverrideHierarchy((Method)handlerMethod.getMethod(), (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE);
            Iterator iterator = methods.iterator();
            while (iterator.hasNext() && (parameterDoc = AnnotationUtils.getAnnotation((AnnotatedElement)(methodOverriden = (Method)iterator.next()).getParameters()[i], annotationType)) == null) {
            }
        }
        return (A)parameterDoc;
    }

    private void setExamples(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        HashMap exampleMap = new HashMap();
        if (parameterDoc.examples().length == 1 && StringUtils.isBlank((CharSequence)parameterDoc.examples()[0].name())) {
            Optional exampleOptional = AnnotationsUtils.getExample((ExampleObject)parameterDoc.examples()[0]);
            exampleOptional.ifPresent(arg_0 -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).setExample(arg_0));
        } else {
            for (ExampleObject exampleObject : parameterDoc.examples()) {
                AnnotationsUtils.getExample((ExampleObject)exampleObject).ifPresent(example -> exampleMap.put(exampleObject.name(), example));
            }
        }
        if (exampleMap.size() > 0) {
            parameter.setExamples(exampleMap);
        }
    }

    private void setExtensions(Parameter parameterDoc, io.swagger.v3.oas.models.parameters.Parameter parameter) {
        if (parameterDoc.extensions().length > 0) {
            Map extensionMap = AnnotationsUtils.getExtensions((Extension[])parameterDoc.extensions());
            extensionMap.forEach((arg_0, arg_1) -> ((io.swagger.v3.oas.models.parameters.Parameter)parameter).addExtension(arg_0, arg_1));
        }
    }

    private void setParameterExplode(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (this.isExplodable(p)) {
            if (Explode.TRUE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.TRUE);
            } else if (Explode.FALSE.equals((Object)p.explode())) {
                parameter.setExplode(Boolean.FALSE);
            }
        }
    }

    private void setParameterStyle(io.swagger.v3.oas.models.parameters.Parameter parameter, Parameter p) {
        if (StringUtils.isNotBlank((CharSequence)p.style().toString())) {
            parameter.setStyle(Parameter.StyleEnum.valueOf((String)p.style().toString().toUpperCase()));
        }
    }

    private boolean isExplodable(Parameter p) {
        Schema schema = p.schema();
        boolean explode = true;
        Class implementation = schema.implementation();
        if (implementation == Void.class && !schema.type().equals("object") && !schema.type().equals("array")) {
            explode = false;
        }
        return explode;
    }

    private JavaType constructType(Type type) {
        return TypeFactory.defaultInstance().constructType(type);
    }
}

