/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.ObjectNodeConverter;

public class SpringDocAnnotationsUtils
extends AnnotationsUtils {
    static final String COMPONENTS_REF = "#/components/schemas/";

    private SpringDocAnnotationsUtils() {
    }

    public static Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components, JsonView jsonView) {
        Schema schemaObject = null;
        PrimitiveType primitiveType = PrimitiveType.fromType(schemaImplementation);
        schemaObject = primitiveType != null ? primitiveType.createProperty() : SpringDocAnnotationsUtils.extractSchema(components, schemaImplementation, jsonView);
        if (schemaObject != null && StringUtils.isBlank((CharSequence)schemaObject.get$ref()) && StringUtils.isBlank((CharSequence)schemaObject.getType())) {
            schemaObject.setType("string");
        }
        return schemaObject;
    }

    public static Schema extractSchema(Components components, Type returnType, JsonView jsonView) {
        Schema schemaN = null;
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true).jsonViewAnnotation(jsonView));
        if (resolvedSchema.schema != null) {
            schemaN = resolvedSchema.schema;
            Map schemaMap = resolvedSchema.referencedSchemas;
            if (schemaMap != null) {
                for (Map.Entry entry : schemaMap.entrySet()) {
                    LinkedHashMap componentSchemas = components.getSchemas();
                    if (componentSchemas == null) {
                        componentSchemas = new LinkedHashMap();
                        componentSchemas.put(entry.getKey(), entry.getValue());
                    } else if (!componentSchemas.containsKey(entry.getKey())) {
                        componentSchemas.put(entry.getKey(), entry.getValue());
                    }
                    components.setSchemas(componentSchemas);
                }
            }
        }
        return schemaN;
    }

    public static Optional<Content> getContent(io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Schema schema, Components components, JsonView jsonViewAnnotation) {
        if (ArrayUtils.isEmpty((Object[])annotationContents)) {
            return Optional.empty();
        }
        Content content = new Content();
        for (io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            MediaType mediaType = SpringDocAnnotationsUtils.getMediaType(schema, components, jsonViewAnnotation, annotationContent);
            ExampleObject[] examples = annotationContent.examples();
            SpringDocAnnotationsUtils.setExamples(mediaType, examples);
            SpringDocAnnotationsUtils.addExtension(annotationContent, mediaType);
            Encoding[] encodings = annotationContent.encoding();
            SpringDocAnnotationsUtils.addEncodingToMediaType(jsonViewAnnotation, mediaType, encodings);
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            if (mediaType.getSchema() == null) continue;
            SpringDocAnnotationsUtils.applyTypes((String[])classTypes, (String[])methodTypes, (Content)content, (MediaType)mediaType);
        }
        if (content.size() == 0 && annotationContents.length != 1) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    private static void addEncodingToMediaType(JsonView jsonViewAnnotation, MediaType mediaType, Encoding[] encodings) {
        for (Encoding encoding : encodings) {
            SpringDocAnnotationsUtils.addEncodingToMediaType((MediaType)mediaType, (Encoding)encoding, (JsonView)jsonViewAnnotation);
        }
    }

    private static void addExtension(io.swagger.v3.oas.annotations.media.Content annotationContent, MediaType mediaType) {
        Map extensions;
        if (annotationContent.extensions() != null && annotationContent.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions((Extension[])annotationContent.extensions())) != null) {
            for (Map.Entry entry : extensions.entrySet()) {
                mediaType.addExtension((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private static void setExamples(MediaType mediaType, ExampleObject[] examples) {
        if (examples.length == 1 && StringUtils.isBlank((CharSequence)examples[0].name())) {
            SpringDocAnnotationsUtils.getExample((ExampleObject)examples[0], (boolean)true).ifPresent(exampleObject -> mediaType.example(exampleObject.getValue()));
        } else {
            for (ExampleObject example : examples) {
                SpringDocAnnotationsUtils.getExample((ExampleObject)example).ifPresent(exampleObject -> mediaType.addExamples(example.name(), exampleObject));
            }
        }
    }

    private static MediaType getMediaType(Schema schema, Components components, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.media.Content annotationContent) {
        MediaType mediaType = new MediaType();
        if (!annotationContent.schema().hidden()) {
            if (components != null) {
                SpringDocAnnotationsUtils.getSchema((io.swagger.v3.oas.annotations.media.Content)annotationContent, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
            } else {
                mediaType.setSchema(schema);
            }
        }
        return mediaType;
    }

    static {
        ModelConverters.getInstance().addConverter((ModelConverter)new ObjectNodeConverter());
    }
}

