/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.AbstractParameterBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.ParameterInfo;
import org.springdoc.core.RequestBodyInfo;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.method.HandlerMethod;

@Component
public class RequestBodyBuilder {
    private final AbstractParameterBuilder parameterBuilder;

    public RequestBodyBuilder(AbstractParameterBuilder parameterBuilder) {
        this.parameterBuilder = parameterBuilder;
    }

    public Optional<RequestBody> buildRequestBodyFromDoc(io.swagger.v3.oas.annotations.parameters.RequestBody requestBody, String[] classConsumes, String[] methodConsumes, Components components, JsonView jsonViewAnnotation) {
        if (requestBody == null) {
            return Optional.empty();
        }
        RequestBody requestBodyObject = new RequestBody();
        boolean isEmpty = true;
        if (StringUtils.isNotBlank((CharSequence)requestBody.ref())) {
            requestBodyObject.set$ref(requestBody.ref());
            return Optional.of(requestBodyObject);
        }
        if (StringUtils.isNotBlank((CharSequence)requestBody.description())) {
            requestBodyObject.setDescription(requestBody.description());
            isEmpty = false;
        }
        if (requestBody.required()) {
            requestBodyObject.setRequired(Boolean.valueOf(requestBody.required()));
            isEmpty = false;
        }
        if (requestBody.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])requestBody.extensions());
            extensions.forEach((arg_0, arg_1) -> ((RequestBody)requestBodyObject).addExtension(arg_0, arg_1));
            isEmpty = false;
        }
        if (requestBody.content().length > 0) {
            isEmpty = false;
        }
        if (isEmpty) {
            return Optional.empty();
        }
        AnnotationsUtils.getContent((io.swagger.v3.oas.annotations.media.Content[])requestBody.content(), (String[])(classConsumes == null ? new String[]{} : classConsumes), (String[])(methodConsumes == null ? new String[]{} : methodConsumes), null, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((RequestBody)requestBodyObject).setContent(arg_0));
        return Optional.of(requestBodyObject);
    }

    public void calculateRequestBodyInfo(Components components, HandlerMethod handlerMethod, MethodAttributes methodAttributes, int i, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        RequestBody requestBody = requestBodyInfo.getRequestBody();
        if (requestBody == null) {
            io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyDoc = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameterInfo.getParameter(), i, io.swagger.v3.oas.annotations.parameters.RequestBody.class);
            requestBody = this.buildRequestBodyFromDoc(requestBodyDoc, methodAttributes.getClassConsumes(), methodAttributes.getMethodConsumes(), components, null).orElse(null);
        }
        RequestPart requestPart = this.parameterBuilder.getParameterAnnotation(handlerMethod, parameterInfo.getParameter(), i, RequestPart.class);
        String paramName = null;
        if (requestPart != null) {
            paramName = (String)StringUtils.defaultIfEmpty((CharSequence)requestPart.value(), (CharSequence)requestPart.name());
        }
        paramName = (String)StringUtils.defaultIfEmpty(paramName, (CharSequence)parameterInfo.getpName());
        parameterInfo.setpName(paramName);
        requestBody = this.buildRequestBody(requestBody, components, methodAttributes, parameterInfo, requestBodyInfo);
        requestBodyInfo.setRequestBody(requestBody);
    }

    private RequestBody buildRequestBody(RequestBody requestBody, Components components, MethodAttributes methodAttributes, ParameterInfo parameterInfo, RequestBodyInfo requestBodyInfo) {
        if (requestBody == null) {
            requestBody = new RequestBody();
        }
        if (parameterInfo.getParameterModel() != null) {
            Parameter parameter = parameterInfo.getParameterModel();
            if (StringUtils.isNotBlank((CharSequence)parameter.getDescription())) {
                requestBody.setDescription(parameter.getDescription());
            }
            if (parameter.getSchema() != null) {
                Schema schema = parameterInfo.getParameterModel().getSchema();
                this.buildContent(requestBody, methodAttributes, schema);
            }
            requestBody.setRequired(parameter.getRequired());
        }
        if (requestBody.getContent() == null || requestBody.getContent() != null && methodAttributes.isMethodOverloaded()) {
            Schema schema = this.parameterBuilder.calculateSchema(components, parameterInfo.getParameter(), parameterInfo.getpName(), requestBodyInfo, methodAttributes.getJsonViewAnnotationForRequestBody());
            this.buildContent(requestBody, methodAttributes, schema);
        }
        return requestBody;
    }

    private void buildContent(RequestBody requestBody, MethodAttributes methodAttributes, Schema<?> schema) {
        Content content = requestBody.getContent();
        if (methodAttributes.isMethodOverloaded() && content != null) {
            for (String value : methodAttributes.getAllConsumes()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else {
            content = new Content();
            for (String value : methodAttributes.getAllConsumes()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        }
        requestBody.setContent(content);
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }
}

