/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.changed.resource;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Consumer;
import org.springaicommunity.mcp.method.changed.resource.AbstractMcpResourceListChangedMethodCallback;

public final class SyncMcpResourceListChangedMethodCallback
extends AbstractMcpResourceListChangedMethodCallback
implements Consumer<List<McpSchema.Resource>> {
    private SyncMcpResourceListChangedMethodCallback(Builder builder) {
        super(builder.method, builder.bean);
    }

    @Override
    public void accept(List<McpSchema.Resource> updatedResources) {
        if (updatedResources == null) {
            throw new IllegalArgumentException("Updated resources list must not be null");
        }
        try {
            Object[] args = this.buildArgs(this.method, null, updatedResources);
            this.method.setAccessible(true);
            this.method.invoke(this.bean, args);
        }
        catch (Exception e) {
            throw new AbstractMcpResourceListChangedMethodCallback.McpResourceListChangedConsumerMethodException("Error invoking resource list changed consumer method: " + this.method.getName(), e);
        }
    }

    @Override
    protected void validateReturnType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE) {
            throw new IllegalArgumentException("Method must have void return type: " + method.getName() + " in " + method.getDeclaringClass().getName() + " returns " + returnType.getName());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends AbstractMcpResourceListChangedMethodCallback.AbstractBuilder<Builder, SyncMcpResourceListChangedMethodCallback> {
        @Override
        public SyncMcpResourceListChangedMethodCallback build() {
            this.validate();
            return new SyncMcpResourceListChangedMethodCallback(this);
        }
    }
}

