/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.method.tool;

import io.modelcontextprotocol.spec.McpSchema;
import java.lang.reflect.Method;
import org.reactivestreams.Publisher;
import org.springaicommunity.mcp.method.tool.AbstractMcpToolMethodCallback;
import org.springaicommunity.mcp.method.tool.ReactiveUtils;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.utils.JsonParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractAsyncMcpToolMethodCallback<T>
extends AbstractMcpToolMethodCallback<T> {
    protected final Class<? extends Throwable> toolCallExceptionClass;

    protected AbstractAsyncMcpToolMethodCallback(ReturnMode returnMode, Method toolMethod, Object toolObject, Class<? extends Throwable> toolCallExceptionClass) {
        super(returnMode, toolMethod, toolObject);
        this.toolCallExceptionClass = toolCallExceptionClass;
    }

    protected Mono<McpSchema.CallToolResult> convertToCallToolResult(Object result) {
        if (result instanceof Mono) {
            Mono monoResult = (Mono)result;
            if (ReactiveUtils.isReactiveReturnTypeOfCallToolResult(this.toolMethod)) {
                return monoResult;
            }
            if (ReactiveUtils.isReactiveReturnTypeOfVoid(this.toolMethod)) {
                return monoResult.then(Mono.just((Object)McpSchema.CallToolResult.builder().addTextContent(JsonParser.toJson("Done")).build()));
            }
            return monoResult.map(this::mapValueToCallToolResult).onErrorResume(e -> Mono.just((Object)McpSchema.CallToolResult.builder().isError(Boolean.valueOf(true)).addTextContent("Error invoking method: %s".formatted(e.getMessage())).build()));
        }
        if (result instanceof Flux) {
            Flux fluxResult = (Flux)result;
            if (ReactiveUtils.isReactiveReturnTypeOfCallToolResult(this.toolMethod)) {
                return fluxResult.next();
            }
            if (ReactiveUtils.isReactiveReturnTypeOfVoid(this.toolMethod)) {
                return fluxResult.then(Mono.just((Object)McpSchema.CallToolResult.builder().addTextContent(JsonParser.toJson("Done")).build()));
            }
            return fluxResult.next().map(this::mapValueToCallToolResult).onErrorResume(e -> Mono.just((Object)McpSchema.CallToolResult.builder().isError(Boolean.valueOf(true)).addTextContent("Error invoking method: %s".formatted(e.getMessage())).build()));
        }
        if (result instanceof Publisher) {
            Publisher publisherResult = (Publisher)result;
            Mono monoFromPublisher = Mono.from((Publisher)publisherResult);
            if (ReactiveUtils.isReactiveReturnTypeOfCallToolResult(this.toolMethod)) {
                return monoFromPublisher;
            }
            if (ReactiveUtils.isReactiveReturnTypeOfVoid(this.toolMethod)) {
                return monoFromPublisher.then(Mono.just((Object)McpSchema.CallToolResult.builder().addTextContent(JsonParser.toJson("Done")).build()));
            }
            return monoFromPublisher.map(this::mapValueToCallToolResult).onErrorResume(e -> Mono.just((Object)McpSchema.CallToolResult.builder().isError(Boolean.valueOf(true)).addTextContent("Error invoking method: %s".formatted(e.getMessage())).build()));
        }
        throw new IllegalStateException("Expected reactive return type but got: " + (result != null ? result.getClass().getName() : "null"));
    }

    protected McpSchema.CallToolResult mapValueToCallToolResult(Object value) {
        return this.convertValueToCallToolResult(value);
    }

    protected Mono<McpSchema.CallToolResult> createAsyncErrorResult(Exception e) {
        Throwable rootCause = this.findCauseUsingPlainJava(e);
        return Mono.just((Object)McpSchema.CallToolResult.builder().isError(Boolean.valueOf(true)).addTextContent(rootCause.getMessage()).build());
    }

    protected Mono<Void> validateRequest(McpSchema.CallToolRequest request) {
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Request must not be null"));
        }
        return Mono.empty();
    }

    @Override
    protected abstract boolean isExchangeOrContextType(Class<?> var1);
}

