/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.complete;

import io.modelcontextprotocol.server.McpStatelessServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.adapter.CompleteAdapter;
import org.springaicommunity.mcp.annotation.McpComplete;
import org.springaicommunity.mcp.method.complete.AsyncStatelessMcpCompleteMethodCallback;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AsyncStatelessMcpCompleteProvider {
    private static final Logger logger = LoggerFactory.getLogger(AsyncStatelessMcpCompleteProvider.class);
    private final List<Object> completeObjects;

    public AsyncStatelessMcpCompleteProvider(List<Object> completeObjects) {
        Assert.notNull(completeObjects, (String)"completeObjects cannot be null");
        this.completeObjects = completeObjects;
    }

    public List<McpStatelessServerFeatures.AsyncCompletionSpecification> getCompleteSpecifications() {
        List<McpStatelessServerFeatures.AsyncCompletionSpecification> completeSpecs = this.completeObjects.stream().map(completeObject -> Stream.of(this.doGetClassMethods(completeObject)).filter(method -> method.isAnnotationPresent(McpComplete.class)).filter(method -> Mono.class.isAssignableFrom(method.getReturnType()) || Flux.class.isAssignableFrom(method.getReturnType()) || Publisher.class.isAssignableFrom(method.getReturnType())).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).map(mcpCompleteMethod -> {
            McpComplete completeAnnotation = mcpCompleteMethod.getAnnotation(McpComplete.class);
            McpSchema.CompleteReference completeRef = CompleteAdapter.asCompleteReference(completeAnnotation, mcpCompleteMethod);
            AsyncStatelessMcpCompleteMethodCallback methodCallback = ((AsyncStatelessMcpCompleteMethodCallback.Builder)((AsyncStatelessMcpCompleteMethodCallback.Builder)((AsyncStatelessMcpCompleteMethodCallback.Builder)AsyncStatelessMcpCompleteMethodCallback.builder().method((Method)mcpCompleteMethod)).bean(completeObject)).complete(completeAnnotation)).build();
            return new McpStatelessServerFeatures.AsyncCompletionSpecification(completeRef, (BiFunction)methodCallback);
        }).toList()).flatMap(Collection::stream).toList();
        if (completeSpecs.isEmpty()) {
            logger.warn("No complete methods found in the provided complete objects: {}", this.completeObjects);
        }
        return completeSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }
}

