/*
 * Decompiled with CFR 0.152.
 */
package org.springaicommunity.mcp.provider.tool;

import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springaicommunity.mcp.annotation.McpTool;
import org.springaicommunity.mcp.method.tool.ReturnMode;
import org.springaicommunity.mcp.method.tool.SyncMcpToolMethodCallback;
import org.springaicommunity.mcp.method.tool.utils.ClassUtils;
import org.springaicommunity.mcp.method.tool.utils.JsonSchemaGenerator;
import reactor.core.publisher.Mono;

public class SyncMcpToolProvider {
    private static final Logger logger = LoggerFactory.getLogger(SyncMcpToolProvider.class);
    private final List<Object> toolObjects;

    public SyncMcpToolProvider(List<Object> toolObjects) {
        Assert.notNull(toolObjects, (String)"toolObjects cannot be null");
        this.toolObjects = toolObjects;
    }

    public List<McpServerFeatures.SyncToolSpecification> getToolSpecifications() {
        List<McpServerFeatures.SyncToolSpecification> toolSpecs = this.toolObjects.stream().map(toolObject -> Stream.of(this.doGetClassMethods(toolObject)).filter(method -> method.isAnnotationPresent(McpTool.class)).filter(method -> !Mono.class.isAssignableFrom(method.getReturnType())).map(mcpToolMethod -> {
            McpSchema.Tool tool;
            boolean useStructuredOtput;
            String inputSchema;
            McpTool toolAnnotation = this.doGetMcpToolAnnotation((Method)mcpToolMethod);
            String toolName = Utils.hasText((String)toolAnnotation.name()) ? toolAnnotation.name() : mcpToolMethod.getName();
            String toolDescription = toolAnnotation.description();
            boolean hasCallToolRequestParam = Arrays.stream(mcpToolMethod.getParameterTypes()).anyMatch(type -> McpSchema.CallToolRequest.class.isAssignableFrom((Class<?>)type));
            if (hasCallToolRequestParam) {
                inputSchema = JsonSchemaGenerator.generateForMethodInput(mcpToolMethod);
                logger.debug("Tool method '{}' uses CallToolRequest parameter, using minimal schema", (Object)toolName);
            } else {
                inputSchema = JsonSchemaGenerator.generateForMethodInput(mcpToolMethod);
            }
            McpSchema.Tool.Builder toolBuilder = McpSchema.Tool.builder().name(toolName).description(toolDescription).inputSchema(inputSchema);
            if (toolAnnotation.annotations() != null) {
                McpTool.McpAnnotations toolAnnotations = toolAnnotation.annotations();
                toolBuilder.annotations(new McpSchema.ToolAnnotations(toolAnnotations.title(), Boolean.valueOf(toolAnnotations.readOnlyHint()), Boolean.valueOf(toolAnnotations.destructiveHint()), Boolean.valueOf(toolAnnotations.idempotentHint()), Boolean.valueOf(toolAnnotations.openWorldHint()), null));
            }
            Class<?> methodReturnType = mcpToolMethod.getReturnType();
            if (toolAnnotation.generateOutputSchema() && methodReturnType != null && methodReturnType != McpSchema.CallToolResult.class && methodReturnType != Void.class && methodReturnType != Void.TYPE && !ClassUtils.isPrimitiveOrWrapper(methodReturnType) && !ClassUtils.isSimpleValueType(methodReturnType)) {
                toolBuilder.outputSchema(JsonSchemaGenerator.generateFromClass(methodReturnType));
            }
            boolean bl = useStructuredOtput = (tool = toolBuilder.build()).outputSchema() != null;
            ReturnMode returnMode = useStructuredOtput ? ReturnMode.STRUCTURED : (methodReturnType == Void.TYPE || methodReturnType == Void.TYPE ? ReturnMode.VOID : ReturnMode.TEXT);
            SyncMcpToolMethodCallback methodCallback = new SyncMcpToolMethodCallback(returnMode, (Method)mcpToolMethod, toolObject);
            McpServerFeatures.SyncToolSpecification toolSpec = McpServerFeatures.SyncToolSpecification.builder().tool(tool).callHandler((BiFunction)methodCallback).build();
            return toolSpec;
        }).toList()).flatMap(Collection::stream).toList();
        if (toolSpecs.isEmpty()) {
            logger.warn("No tool methods found in the provided tool objects: {}", this.toolObjects);
        }
        return toolSpecs;
    }

    protected Method[] doGetClassMethods(Object bean) {
        return bean.getClass().getDeclaredMethods();
    }

    protected McpTool doGetMcpToolAnnotation(Method method) {
        return method.getAnnotation(McpTool.class);
    }
}

