/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ws.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.server.ws.ws.WebServicesWsAction;

public class ListAction
implements WebServicesWsAction {
    private WebService.Context context;

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("list").setSince("4.2").setDescription("List web services").setResponseExample(this.getClass().getResource("list-example.json")).setHandler((RequestHandler)this);
        action.createParam("include_internals").setDescription("Include web services that are implemented for internal use only. Their forward-compatibility is not assured").setBooleanPossibleValues().setDefaultValue((Object)"false");
    }

    public void handle(Request request, Response response) throws Exception {
        Preconditions.checkState((this.context != null && !this.context.controllers().isEmpty() ? 1 : 0) != 0, (Object)"Web service controllers must be loaded before calling the action");
        boolean includeInternals = request.mandatoryParamAsBoolean("include_internals");
        JsonWriter writer = response.newJsonWriter();
        writer.beginObject();
        writer.name("webServices").beginArray();
        Ordering ordering = Ordering.natural().onResultOf(WebService.Controller::path);
        for (WebService.Controller controller : ordering.sortedCopy((Iterable)this.context.controllers())) {
            ListAction.writeController(writer, controller, includeInternals);
        }
        writer.endArray();
        writer.endObject();
        writer.close();
    }

    @Override
    public void setContext(WebService.Context context) {
        this.context = context;
    }

    private static void writeController(JsonWriter writer, WebService.Controller controller, boolean includeInternals) {
        if (includeInternals || !controller.isInternal()) {
            writer.beginObject();
            writer.prop("path", controller.path());
            writer.prop("since", controller.since());
            writer.prop("description", controller.description());
            Ordering ordering = Ordering.natural().onResultOf(WebService.Action::key);
            writer.name("actions").beginArray();
            for (WebService.Action action : ordering.sortedCopy((Iterable)controller.actions())) {
                ListAction.writeAction(writer, action, includeInternals);
            }
            writer.endArray();
            writer.endObject();
        }
    }

    private static void writeAction(JsonWriter writer, WebService.Action action, boolean includeInternals) {
        if (includeInternals || !action.isInternal()) {
            writer.beginObject();
            writer.prop("key", action.key());
            writer.prop("description", action.description());
            writer.prop("since", action.since());
            writer.prop("deprecatedSince", action.deprecatedSince());
            writer.prop("internal", action.isInternal());
            writer.prop("post", action.isPost());
            writer.prop("hasResponseExample", action.responseExample() != null);
            ListAction.writeChangelog(writer, action);
            ListAction.writeParameters(writer, action, includeInternals);
            writer.endObject();
        }
    }

    private static void writeParameters(JsonWriter writer, WebService.Action action, boolean includeInternals) {
        List params = (List)action.params().stream().filter(p -> includeInternals || !p.isInternal()).collect(MoreCollectors.toList());
        if (!params.isEmpty()) {
            Ordering ordering = Ordering.natural().onResultOf(WebService.Param::key);
            writer.name("params").beginArray();
            for (WebService.Param param : ordering.sortedCopy((Iterable)params)) {
                ListAction.writeParam(writer, param);
            }
            writer.endArray();
        }
    }

    private static void writeParam(JsonWriter writer, WebService.Param param) {
        writer.beginObject();
        writer.prop("key", param.key());
        writer.prop("description", param.description());
        writer.prop("since", param.since());
        writer.prop("required", param.isRequired());
        writer.prop("internal", param.isInternal());
        writer.prop("defaultValue", param.defaultValue());
        writer.prop("exampleValue", param.exampleValue());
        writer.prop("deprecatedSince", param.deprecatedSince());
        writer.prop("deprecatedKey", param.deprecatedKey());
        writer.prop("deprecatedKeySince", param.deprecatedKeySince());
        writer.prop("maxValuesAllowed", (Number)param.maxValuesAllowed());
        Optional.ofNullable(param.possibleValues()).ifPresent(possibleValues -> writer.name("possibleValues").beginArray().values((Iterable)possibleValues).endArray());
        Optional.ofNullable(param.maximumLength()).ifPresent(maximumLength -> writer.prop("maximumLength", (Number)maximumLength));
        Optional.ofNullable(param.minimumLength()).ifPresent(minimumLength -> writer.prop("minimumLength", (Number)minimumLength));
        Optional.ofNullable(param.maximumValue()).ifPresent(maximumValue -> writer.prop("maximumValue", (Number)maximumValue));
        writer.endObject();
    }

    private static void writeChangelog(JsonWriter writer, WebService.Action action) {
        writer.name("changelog").beginArray();
        action.changelog().stream().sorted(Comparator.comparing(Change::getVersion).reversed()).forEach(changelog -> {
            writer.beginObject();
            writer.prop("description", changelog.getDescription());
            writer.prop("version", changelog.getVersion());
            writer.endObject();
        });
        writer.endArray();
    }
}

