/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.webhook;

import com.google.common.base.Throwables;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.server.webhook.Webhook;
import org.sonar.server.webhook.WebhookPayload;

@Immutable
public class WebhookDelivery {
    private final Webhook webhook;
    private final WebhookPayload payload;
    private final Integer httpStatus;
    private final Integer durationInMs;
    private final long at;
    private final Throwable error;

    private WebhookDelivery(Builder builder) {
        this.webhook = Objects.requireNonNull(builder.webhook);
        this.payload = Objects.requireNonNull(builder.payload);
        this.httpStatus = builder.httpStatus;
        this.durationInMs = builder.durationInMs;
        this.at = builder.at;
        this.error = builder.error;
    }

    public Webhook getWebhook() {
        return this.webhook;
    }

    public WebhookPayload getPayload() {
        return this.payload;
    }

    public Optional<Integer> getHttpStatus() {
        return Optional.ofNullable(this.httpStatus);
    }

    public Optional<Integer> getDurationInMs() {
        return Optional.ofNullable(this.durationInMs);
    }

    public long getAt() {
        return this.at;
    }

    public Optional<Throwable> getError() {
        return Optional.ofNullable(this.error);
    }

    public Optional<String> getErrorMessage() {
        return this.error != null ? Optional.ofNullable(Throwables.getRootCause((Throwable)this.error).getMessage()) : Optional.empty();
    }

    public boolean isSuccess() {
        return this.httpStatus != null && this.httpStatus >= 200 && this.httpStatus < 300;
    }

    public static class Builder {
        private Webhook webhook;
        private WebhookPayload payload;
        private Integer httpStatus;
        private Integer durationInMs;
        private long at;
        private Throwable error;

        public Builder setWebhook(Webhook w) {
            this.webhook = w;
            return this;
        }

        public Builder setPayload(WebhookPayload payload) {
            this.payload = payload;
            return this;
        }

        public Builder setHttpStatus(@Nullable Integer httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        public Builder setDurationInMs(@Nullable Integer durationInMs) {
            this.durationInMs = durationInMs;
            return this;
        }

        public Builder setAt(long at) {
            this.at = at;
            return this;
        }

        public Builder setError(@Nullable Throwable t) {
            this.error = t;
            return this;
        }

        public WebhookDelivery build() {
            return new WebhookDelivery(this);
        }
    }
}

