/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.util;

import com.google.common.base.Throwables;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.log.Loggers;

public class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static Collection<String> listFiles(ClassLoader classLoader, String rootPath) {
        return ClassLoaderUtils.listResources(classLoader, rootPath, path -> !StringUtils.endsWith((String)path, (String)"/"));
    }

    public static Collection<String> listResources(ClassLoader classLoader, String rootPath, Predicate<String> predicate) {
        String jarPath = null;
        JarFile jar = null;
        try {
            ArrayList<String> paths = new ArrayList<String>();
            URL root = classLoader.getResource(rootPath);
            if (root != null) {
                ClassLoaderUtils.checkJarFile(root);
                String rootDirectory = rootPath;
                if (StringUtils.substringAfterLast((String)rootPath, (String)"/").indexOf(46) >= 0) {
                    rootDirectory = StringUtils.substringBeforeLast((String)rootPath, (String)"/");
                }
                jarPath = root.getPath().substring(5, root.getPath().indexOf(33));
                jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8.name()));
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String name = entries.nextElement().getName();
                    if (!name.startsWith(rootDirectory) || !predicate.test(name)) continue;
                    paths.add(name);
                }
            }
            ArrayList<String> arrayList = paths;
            return arrayList;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        finally {
            ClassLoaderUtils.closeJar(jar, jarPath);
        }
    }

    private static void closeJar(@Nullable JarFile jar, String jarPath) {
        if (jar != null) {
            try {
                jar.close();
            }
            catch (Exception e) {
                Loggers.get(ClassLoaderUtils.class).error("Fail to close JAR file: " + jarPath, (Throwable)e);
            }
        }
    }

    private static void checkJarFile(URL root) {
        if (!"jar".equals(root.getProtocol())) {
            throw new IllegalStateException("Unsupported protocol: " + root.getProtocol());
        }
    }
}

