/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.usertoken.ws;

import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.server.ws.Request;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.user.UserDto;
import org.sonar.server.user.AbstractUserSession;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class UserTokenSupport {
    static final String CONTROLLER = "api/user_tokens";
    static final String ACTION_SEARCH = "search";
    static final String ACTION_REVOKE = "revoke";
    static final String ACTION_GENERATE = "generate";
    static final String PARAM_LOGIN = "login";
    static final String PARAM_NAME = "name";
    private final DbClient dbClient;
    private final UserSession userSession;

    public UserTokenSupport(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    UserDto getUser(DbSession dbSession, Request request) {
        String login = request.param(PARAM_LOGIN);
        login = login == null ? this.userSession.getLogin() : login;
        UserTokenSupport.validate(this.userSession, login);
        UserDto user = this.dbClient.userDao().selectByLogin(dbSession, Objects.requireNonNull(login, "Login should not be null"));
        WsUtils.checkFound(user, "User with login '%s' doesn't exist", login);
        return user;
    }

    private static void validate(UserSession userSession, @Nullable String requestLogin) {
        userSession.checkLoggedIn();
        if (userSession.isSystemAdministrator() || UserTokenSupport.isLoggedInUser(userSession, requestLogin)) {
            return;
        }
        throw AbstractUserSession.insufficientPrivilegesException();
    }

    private static boolean isLoggedInUser(UserSession userSession, @Nullable String requestLogin) {
        return requestLogin != null && requestLogin.equals(userSession.getLogin());
    }
}

