/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.user.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.index.IndexRequest;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.es.EsQueueDto;
import org.sonar.db.user.UserDto;
import org.sonar.server.es.BulkIndexer;
import org.sonar.server.es.EsClient;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.IndexingListener;
import org.sonar.server.es.IndexingResult;
import org.sonar.server.es.OneToOneResilientIndexingListener;
import org.sonar.server.es.ResilientIndexer;
import org.sonar.server.user.index.UserDoc;
import org.sonar.server.user.index.UserIndexDefinition;

public class UserIndexer
implements ResilientIndexer {
    private final DbClient dbClient;
    private final EsClient esClient;

    public UserIndexer(DbClient dbClient, EsClient esClient) {
        this.dbClient = dbClient;
        this.esClient = esClient;
    }

    @Override
    public Set<IndexType> getIndexTypes() {
        return ImmutableSet.of((Object)UserIndexDefinition.INDEX_TYPE_USER);
    }

    @Override
    public void indexOnStartup(Set<IndexType> uninitializedIndexTypes) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            ArrayListMultimap organizationUuidsByUserUuid = ArrayListMultimap.create();
            this.dbClient.organizationMemberDao().selectAllForUserIndexing(dbSession, (arg_0, arg_1) -> ((ListMultimap)organizationUuidsByUserUuid).put(arg_0, arg_1));
            BulkIndexer bulkIndexer = this.newBulkIndexer(BulkIndexer.Size.LARGE, IndexingListener.FAIL_ON_ERROR);
            bulkIndexer.start();
            this.dbClient.userDao().scrollAll(dbSession, arg_0 -> UserIndexer.lambda$indexOnStartup$0(bulkIndexer, (ListMultimap)organizationUuidsByUserUuid, arg_0));
            bulkIndexer.stop();
        }
    }

    public void commitAndIndex(DbSession dbSession, UserDto user) {
        this.commitAndIndex(dbSession, Collections.singletonList(user));
    }

    public void commitAndIndex(DbSession dbSession, Collection<UserDto> users) {
        List uuids = (List)users.stream().map(UserDto::getUuid).collect(MoreCollectors.toList());
        List items = (List)uuids.stream().map(uuid -> EsQueueDto.create((String)UserIndexDefinition.INDEX_TYPE_USER.format(), (String)uuid)).collect(MoreCollectors.toArrayList());
        this.dbClient.esQueueDao().insert(dbSession, (Collection)items);
        dbSession.commit();
        this.postCommit(dbSession, (Collection)users.stream().map(UserDto::getLogin).collect(MoreCollectors.toList()), items);
    }

    private void postCommit(DbSession dbSession, Collection<String> logins, Collection<EsQueueDto> items) {
        this.index(dbSession, items);
    }

    @Override
    public IndexingResult index(DbSession dbSession, Collection<EsQueueDto> items) {
        if (items.isEmpty()) {
            return new IndexingResult();
        }
        Set uuids = (Set)items.stream().map(EsQueueDto::getDocId).collect(MoreCollectors.toHashSet((int)items.size()));
        ArrayListMultimap organizationUuidsByUserUuid = ArrayListMultimap.create();
        this.dbClient.organizationMemberDao().selectForUserIndexing(dbSession, (Collection)uuids, (arg_0, arg_1) -> ((ListMultimap)organizationUuidsByUserUuid).put(arg_0, arg_1));
        BulkIndexer bulkIndexer = this.newBulkIndexer(BulkIndexer.Size.REGULAR, new OneToOneResilientIndexingListener(this.dbClient, dbSession, items));
        bulkIndexer.start();
        this.dbClient.userDao().scrollByUuids(dbSession, (Collection)uuids, arg_0 -> UserIndexer.lambda$index$2(uuids, bulkIndexer, (ListMultimap)organizationUuidsByUserUuid, arg_0));
        uuids.forEach(uuid -> bulkIndexer.addDeletion(UserIndexDefinition.INDEX_TYPE_USER, (String)uuid));
        return bulkIndexer.stop();
    }

    private BulkIndexer newBulkIndexer(BulkIndexer.Size bulkSize, IndexingListener listener) {
        return new BulkIndexer(this.esClient, UserIndexDefinition.INDEX_TYPE_USER, bulkSize, listener);
    }

    private static IndexRequest newIndexRequest(UserDto user, ListMultimap<String, String> organizationUuidsByUserUuid) {
        UserDoc doc = new UserDoc(Maps.newHashMapWithExpectedSize((int)8));
        doc.setUuid(user.getUuid());
        doc.setLogin(user.getLogin());
        doc.setName(user.getName());
        doc.setEmail(user.getEmail());
        doc.setActive(user.isActive());
        doc.setScmAccounts(UserDto.decodeScmAccounts((String)user.getScmAccounts()));
        doc.setOrganizationUuids(organizationUuidsByUserUuid.get((Object)user.getUuid()));
        return new IndexRequest(UserIndexDefinition.INDEX_TYPE_USER.getIndex(), UserIndexDefinition.INDEX_TYPE_USER.getType()).id(doc.getId()).routing(doc.getRouting()).source(doc.getFields());
    }

    private static /* synthetic */ void lambda$index$2(Set uuids, BulkIndexer bulkIndexer, ListMultimap organizationUuidsByUserUuid, UserDto u) {
        uuids.remove(u.getUuid());
        bulkIndexer.add(UserIndexer.newIndexRequest(u, (ListMultimap<String, String>)organizationUuidsByUserUuid));
    }

    private static /* synthetic */ void lambda$indexOnStartup$0(BulkIndexer bulkIndexer, ListMultimap organizationUuidsByUserUuid, UserDto u) {
        bulkIndexer.add(UserIndexer.newIndexRequest(u, (ListMultimap<String, String>)organizationUuidsByUserUuid));
    }
}

