/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.ui.ws;

import java.util.List;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.api.web.page.Page;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.BillingValidations;
import org.sonar.server.organization.BillingValidationsProxy;
import org.sonar.server.organization.DefaultOrganizationProvider;
import org.sonar.server.project.Visibility;
import org.sonar.server.ui.PageRepository;
import org.sonar.server.ui.ws.NavigationWsAction;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;

public class OrganizationAction
implements NavigationWsAction {
    private static final String ACTION_NAME = "organization";
    private static final String PARAM_ORGANIZATION = "organization";
    private final DbClient dbClient;
    private final DefaultOrganizationProvider defaultOrganizationProvider;
    private final UserSession userSession;
    private final PageRepository pageRepository;
    private final BillingValidationsProxy billingValidations;

    public OrganizationAction(DbClient dbClient, DefaultOrganizationProvider defaultOrganizationProvider, UserSession userSession, PageRepository pageRepository, BillingValidationsProxy billingValidations) {
        this.dbClient = dbClient;
        this.defaultOrganizationProvider = defaultOrganizationProvider;
        this.userSession = userSession;
        this.pageRepository = pageRepository;
        this.billingValidations = billingValidations;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction projectNavigation = context.createAction("organization").setDescription("Get information concerning organization navigation for the current user").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("organization-example.json")).setSince("6.3").setChangelog(new Change[]{new Change("6.4", "The field 'projectVisibility' is added")});
        projectNavigation.createParam("organization").setRequired(true).setDescription("the organization key").setExampleValue((Object)"my-org");
    }

    public void handle(Request request, Response response) throws Exception {
        String organizationKey = request.mandatoryParam("organization");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto organization = (OrganizationDto)WsUtils.checkFoundWithOptional(this.dbClient.organizationDao().selectByKey(dbSession, organizationKey), "No organization with key '%s'", organizationKey);
            boolean newProjectPrivate = this.dbClient.organizationDao().getNewProjectPrivate(dbSession, organization);
            JsonWriter json = response.newJsonWriter();
            json.beginObject();
            this.writeOrganization(json, organization, newProjectPrivate);
            json.endObject().close();
        }
    }

    private void writeOrganization(JsonWriter json, OrganizationDto organization, boolean newProjectPrivate) {
        json.name("organization").beginObject().prop("canAdmin", this.userSession.hasPermission(OrganizationPermission.ADMINISTER, organization)).prop("canProvisionProjects", this.userSession.hasPermission(OrganizationPermission.PROVISION_PROJECTS, organization)).prop("canDelete", organization.isGuarded() ? this.userSession.isSystemAdministrator() : this.userSession.hasPermission(OrganizationPermission.ADMINISTER, organization)).prop("isDefault", organization.getKey().equals(this.defaultOrganizationProvider.get().getKey())).prop("projectVisibility", Visibility.getLabel(newProjectPrivate)).prop("canUpdateProjectsVisibilityToPrivate", this.userSession.hasPermission(OrganizationPermission.ADMINISTER, organization) && this.billingValidations.canUpdateProjectVisibilityToPrivate(new BillingValidations.Organization(organization.getKey(), organization.getUuid())));
        json.name("pages");
        OrganizationAction.writePages(json, this.pageRepository.getOrganizationPages(false));
        if (this.userSession.hasPermission(OrganizationPermission.ADMINISTER, organization)) {
            json.name("adminPages");
            OrganizationAction.writePages(json, this.pageRepository.getOrganizationPages(true));
        }
        json.endObject();
    }

    private static void writePages(JsonWriter json, List<Page> pages) {
        json.beginArray();
        pages.forEach(p -> json.beginObject().prop("key", p.getKey()).prop("name", p.getName()).endObject());
        json.endArray();
    }
}

