/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.PropertyDefinitions;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.setting.ws.PropertySetExtractor;

public class SettingsUpdater {
    private final DbClient dbClient;
    private final PropertyDefinitions definitions;

    public SettingsUpdater(DbClient dbClient, PropertyDefinitions definitions) {
        this.dbClient = dbClient;
        this.definitions = definitions;
    }

    public void deleteGlobalSettings(DbSession dbSession, String ... settingKeys) {
        this.deleteGlobalSettings(dbSession, Arrays.asList(settingKeys));
    }

    public void deleteGlobalSettings(DbSession dbSession, List<String> settingKeys) {
        Preconditions.checkArgument((!settingKeys.isEmpty() ? 1 : 0) != 0, (Object)"At least one setting key is required");
        settingKeys.forEach(key -> this.delete(dbSession, (String)key, Optional.empty()));
    }

    public void deleteComponentSettings(DbSession dbSession, ComponentDto componentDto, String ... settingKeys) {
        this.deleteComponentSettings(dbSession, componentDto, Arrays.asList(settingKeys));
    }

    public void deleteComponentSettings(DbSession dbSession, ComponentDto componentDto, List<String> settingKeys) {
        Preconditions.checkArgument((!settingKeys.isEmpty() ? 1 : 0) != 0, (Object)"At least one setting key is required");
        for (String propertyKey : settingKeys) {
            this.delete(dbSession, propertyKey, Optional.of(componentDto));
        }
    }

    private void delete(DbSession dbSession, String settingKey, Optional<ComponentDto> componentDto) {
        PropertyDefinition definition = this.definitions.get(settingKey);
        if (definition == null || !definition.type().equals((Object)PropertyType.PROPERTY_SET)) {
            this.deleteSetting(dbSession, settingKey, componentDto);
        } else {
            this.deletePropertySet(dbSession, settingKey, definition, componentDto);
        }
    }

    private void deleteSetting(DbSession dbSession, String settingKey, Optional<ComponentDto> componentDto) {
        if (componentDto.isPresent()) {
            this.dbClient.propertiesDao().deleteProjectProperty(settingKey, componentDto.get().getId(), dbSession);
        } else {
            this.dbClient.propertiesDao().deleteGlobalProperty(settingKey, dbSession);
        }
    }

    private void deletePropertySet(DbSession dbSession, String settingKey, PropertyDefinition definition, Optional<ComponentDto> componentDto) {
        Optional<PropertyDto> propertyDto = this.selectPropertyDto(dbSession, settingKey, componentDto);
        if (!propertyDto.isPresent()) {
            return;
        }
        Set<String> settingSetKeys = PropertySetExtractor.extractPropertySetKeys(propertyDto.get(), definition);
        for (String key : settingSetKeys) {
            this.deleteSetting(dbSession, key, componentDto);
        }
        this.deleteSetting(dbSession, settingKey, componentDto);
    }

    private Optional<PropertyDto> selectPropertyDto(DbSession dbSession, String settingKey, Optional<ComponentDto> componentDto) {
        if (componentDto.isPresent()) {
            return Optional.ofNullable(this.dbClient.propertiesDao().selectProjectProperty(dbSession, componentDto.get().getId().longValue(), settingKey));
        }
        return Optional.ofNullable(this.dbClient.propertiesDao().selectGlobalProperty(dbSession, settingKey));
    }
}

