/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.ws;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.debt.internal.DefaultDebtRemediationFunction;
import org.sonar.api.utils.DateUtils;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleDto;
import org.sonar.db.rule.RuleMetadataDto;
import org.sonar.db.rule.RuleParamDto;
import org.sonar.db.user.UserDto;
import org.sonar.markdown.Markdown;
import org.sonar.server.rule.ws.SearchAction;
import org.sonar.server.text.MacroInterpreter;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Rules;

public class RuleMapper {
    private final Languages languages;
    private final MacroInterpreter macroInterpreter;

    public RuleMapper(Languages languages, MacroInterpreter macroInterpreter) {
        this.languages = languages;
        this.macroInterpreter = macroInterpreter;
    }

    public Rules.Rule toWsRule(RuleDefinitionDto ruleDefinitionDto, SearchAction.SearchResult result, Set<String> fieldsToReturn) {
        Rules.Rule.Builder ruleResponse = Rules.Rule.newBuilder();
        this.applyRuleDefinition(ruleResponse, ruleDefinitionDto, result, fieldsToReturn);
        return ruleResponse.build();
    }

    public Rules.Rule toWsRule(RuleDefinitionDto ruleDefinitionDto, SearchAction.SearchResult result, Set<String> fieldsToReturn, RuleMetadataDto metadata, Map<String, UserDto> usersByUuid) {
        Rules.Rule.Builder ruleResponse = Rules.Rule.newBuilder();
        this.applyRuleDefinition(ruleResponse, ruleDefinitionDto, result, fieldsToReturn);
        this.applyRuleMetadata(ruleResponse, metadata, usersByUuid, fieldsToReturn);
        RuleMapper.setDebtRemediationFunctionFields(ruleResponse, ruleDefinitionDto, metadata, fieldsToReturn);
        return ruleResponse.build();
    }

    public Rules.Rule.Builder applyRuleDefinition(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDefinitionDto, SearchAction.SearchResult result, Set<String> fieldsToReturn) {
        ruleResponse.setKey(ruleDefinitionDto.getKey().toString());
        ruleResponse.setType(Common.RuleType.forNumber((int)ruleDefinitionDto.getType()));
        RuleMapper.setRepository(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setName(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setStatus(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setSysTags(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setParams(ruleResponse, ruleDefinitionDto, result, fieldsToReturn);
        RuleMapper.setCreatedAt(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        this.setDescriptionFields(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setSeverity(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setInternalKey(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setLanguage(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        this.setLanguageName(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setIsTemplate(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setIsExternal(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setTemplateKey(ruleResponse, ruleDefinitionDto, result, fieldsToReturn);
        RuleMapper.setDefaultDebtRemediationFunctionFields(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setEffortToFixDescription(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        RuleMapper.setScope(ruleResponse, ruleDefinitionDto, fieldsToReturn);
        return ruleResponse;
    }

    private void applyRuleMetadata(Rules.Rule.Builder ruleResponse, RuleMetadataDto metadata, Map<String, UserDto> usersByUuid, Set<String> fieldsToReturn) {
        RuleMapper.setTags(ruleResponse, metadata, fieldsToReturn);
        this.setNotesFields(ruleResponse, metadata, usersByUuid, fieldsToReturn);
        RuleMapper.setIsRemediationFunctionOverloaded(ruleResponse, metadata, fieldsToReturn);
    }

    private static void setRepository(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "repo")) {
            ruleResponse.setRepo(ruleDto.getKey().repository());
        }
    }

    private static void setScope(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "scope")) {
            ruleResponse.setScope(RuleMapper.toWsRuleScope(ruleDto.getScope()));
        }
    }

    private static Common.RuleScope toWsRuleScope(RuleDto.Scope scope) {
        switch (scope) {
            case ALL: {
                return Common.RuleScope.ALL;
            }
            case MAIN: {
                return Common.RuleScope.MAIN;
            }
            case TEST: {
                return Common.RuleScope.TEST;
            }
        }
        throw new IllegalArgumentException("Unknown rule scope: " + scope);
    }

    private static void setEffortToFixDescription(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if ((RuleMapper.shouldReturnField(fieldsToReturn, "effortToFixDescription") || RuleMapper.shouldReturnField(fieldsToReturn, "gapDescription")) && ruleDto.getGapDescription() != null) {
            ruleResponse.setEffortToFixDescription(ruleDto.getGapDescription());
            ruleResponse.setGapDescription(ruleDto.getGapDescription());
        }
    }

    private static void setIsRemediationFunctionOverloaded(Rules.Rule.Builder ruleResponse, RuleMetadataDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "debtOverloaded") || RuleMapper.shouldReturnField(fieldsToReturn, "remFnOverloaded")) {
            ruleResponse.setDebtOverloaded(RuleMapper.isRemediationFunctionOverloaded(ruleDto));
            ruleResponse.setRemFnOverloaded(RuleMapper.isRemediationFunctionOverloaded(ruleDto));
        }
    }

    private static void setDefaultDebtRemediationFunctionFields(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        DebtRemediationFunction defaultDebtRemediationFunction;
        if ((RuleMapper.shouldReturnField(fieldsToReturn, "defaultDebtRemFn") || RuleMapper.shouldReturnField(fieldsToReturn, "defaultRemFn")) && (defaultDebtRemediationFunction = RuleMapper.defaultDebtRemediationFunction(ruleDto)) != null) {
            String baseEffort;
            String gapMultiplier = defaultDebtRemediationFunction.gapMultiplier();
            if (gapMultiplier != null) {
                ruleResponse.setDefaultRemFnGapMultiplier(gapMultiplier);
                ruleResponse.setDefaultDebtRemFnCoeff(gapMultiplier);
            }
            if ((baseEffort = defaultDebtRemediationFunction.baseEffort()) != null) {
                ruleResponse.setDefaultRemFnBaseEffort(baseEffort);
                ruleResponse.setDefaultDebtRemFnOffset(baseEffort);
            }
            if (defaultDebtRemediationFunction.type() != null) {
                ruleResponse.setDefaultRemFnType(defaultDebtRemediationFunction.type().name());
                ruleResponse.setDefaultDebtRemFnType(defaultDebtRemediationFunction.type().name());
            }
        }
    }

    private static void setDebtRemediationFunctionFields(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDefinitionDto, RuleMetadataDto ruleMetadataDto, Set<String> fieldsToReturn) {
        DebtRemediationFunction debtRemediationFunction;
        if ((RuleMapper.shouldReturnField(fieldsToReturn, "debtRemFn") || RuleMapper.shouldReturnField(fieldsToReturn, "remFn")) && (debtRemediationFunction = RuleMapper.debtRemediationFunction(ruleDefinitionDto, ruleMetadataDto)) != null) {
            String baseEffort;
            String gapMultiplier;
            if (debtRemediationFunction.type() != null) {
                ruleResponse.setRemFnType(debtRemediationFunction.type().name());
                ruleResponse.setDebtRemFnType(debtRemediationFunction.type().name());
            }
            if ((gapMultiplier = debtRemediationFunction.gapMultiplier()) != null) {
                ruleResponse.setRemFnGapMultiplier(gapMultiplier);
                ruleResponse.setDebtRemFnCoeff(gapMultiplier);
            }
            if ((baseEffort = debtRemediationFunction.baseEffort()) != null) {
                ruleResponse.setRemFnBaseEffort(baseEffort);
                ruleResponse.setDebtRemFnOffset(baseEffort);
            }
        }
    }

    private static void setName(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "name") && ruleDto.getName() != null) {
            ruleResponse.setName(ruleDto.getName());
        }
    }

    private static void setStatus(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "status") && ruleDto.getStatus() != null) {
            ruleResponse.setStatus(Common.RuleStatus.valueOf((String)ruleDto.getStatus().toString()));
        }
    }

    private static void setTags(Rules.Rule.Builder ruleResponse, RuleMetadataDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "tags")) {
            ruleResponse.getTagsBuilder().addAllTags((Iterable)ruleDto.getTags());
        }
    }

    private static void setSysTags(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "sysTags")) {
            ruleResponse.getSysTagsBuilder().addAllSysTags((Iterable)ruleDto.getSystemTags());
        }
    }

    private static void setParams(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, SearchAction.SearchResult searchResult, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "params")) {
            List ruleParameters = searchResult.getRuleParamsByRuleId().get((Object)ruleDto.getId());
            ruleResponse.getParamsBuilder().addAllParams((Iterable)FluentIterable.from((Iterable)ruleParameters).transform((Function)RuleParamDtoToWsRuleParam.INSTANCE).toList());
        }
    }

    private static void setCreatedAt(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "createdAt")) {
            ruleResponse.setCreatedAt(DateUtils.formatDateTime((long)ruleDto.getCreatedAt()));
        }
    }

    private void setDescriptionFields(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        String description;
        if (RuleMapper.shouldReturnField(fieldsToReturn, "htmlDesc") && (description = ruleDto.getDescription()) != null) {
            switch (ruleDto.getDescriptionFormat()) {
                case MARKDOWN: {
                    ruleResponse.setHtmlDesc(this.macroInterpreter.interpret(Markdown.convertToHtml((String)description)));
                    break;
                }
                case HTML: {
                    ruleResponse.setHtmlDesc(this.macroInterpreter.interpret(description));
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Rule description format '%s' is unknown for key '%s'", ruleDto.getDescriptionFormat(), ruleDto.getKey().toString()));
                }
            }
        }
        if (RuleMapper.shouldReturnField(fieldsToReturn, "mdDesc") && ruleDto.getDescription() != null) {
            ruleResponse.setMdDesc(ruleDto.getDescription());
        }
    }

    private void setNotesFields(Rules.Rule.Builder ruleResponse, RuleMetadataDto ruleDto, Map<String, UserDto> usersByUuid, Set<String> fieldsToReturn) {
        String noteData = ruleDto.getNoteData();
        if (RuleMapper.shouldReturnField(fieldsToReturn, "htmlNote") && noteData != null) {
            ruleResponse.setHtmlNote(this.macroInterpreter.interpret(Markdown.convertToHtml((String)noteData)));
        }
        if (RuleMapper.shouldReturnField(fieldsToReturn, "mdNote") && noteData != null) {
            ruleResponse.setMdNote(noteData);
        }
        String userUuid = ruleDto.getNoteUserUuid();
        if (RuleMapper.shouldReturnField(fieldsToReturn, "noteLogin") && userUuid != null) {
            ruleResponse.setNoteLogin(usersByUuid.get(userUuid).getLogin());
        }
    }

    private static void setSeverity(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        String severity = ruleDto.getSeverityString();
        if (RuleMapper.shouldReturnField(fieldsToReturn, "severity") && severity != null) {
            ruleResponse.setSeverity(severity);
        }
    }

    private static void setInternalKey(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "internalKey") && ruleDto.getConfigKey() != null) {
            ruleResponse.setInternalKey(ruleDto.getConfigKey());
        }
    }

    private static void setLanguage(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        String language = ruleDto.getLanguage();
        if (RuleMapper.shouldReturnField(fieldsToReturn, "lang") && language != null) {
            ruleResponse.setLang(language);
        }
    }

    private void setLanguageName(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "langName") && ruleDto.getLanguage() != null) {
            String languageKey = ruleDto.getLanguage();
            Language language = this.languages.get(languageKey);
            ruleResponse.setLangName(language == null ? languageKey : language.getName());
        }
    }

    private static void setIsTemplate(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "isTemplate")) {
            ruleResponse.setIsTemplate(ruleDto.isTemplate());
        }
    }

    private static void setIsExternal(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, Set<String> fieldsToReturn) {
        if (RuleMapper.shouldReturnField(fieldsToReturn, "isExternal")) {
            ruleResponse.setIsExternal(ruleDto.isExternal());
        }
    }

    private static void setTemplateKey(Rules.Rule.Builder ruleResponse, RuleDefinitionDto ruleDto, SearchAction.SearchResult result, Set<String> fieldsToReturn) {
        RuleDefinitionDto templateRule;
        if (RuleMapper.shouldReturnField(fieldsToReturn, "templateKey") && ruleDto.isCustomRule() && (templateRule = result.getTemplateRulesByRuleId().get(ruleDto.getTemplateId())) != null) {
            ruleResponse.setTemplateKey(templateRule.getKey().toString());
        }
    }

    private static boolean shouldReturnField(Set<String> fieldsToReturn, String fieldName) {
        return fieldsToReturn.isEmpty() || fieldsToReturn.contains(fieldName);
    }

    private static boolean isRemediationFunctionOverloaded(RuleMetadataDto rule) {
        return rule.getRemediationFunction() != null;
    }

    @CheckForNull
    private static DebtRemediationFunction defaultDebtRemediationFunction(RuleDefinitionDto ruleDto) {
        String function = ruleDto.getDefRemediationFunction();
        if (function == null || function.isEmpty()) {
            return null;
        }
        return new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.valueOf((String)function.toUpperCase(Locale.ENGLISH)), ruleDto.getDefRemediationGapMultiplier(), ruleDto.getDefRemediationBaseEffort());
    }

    @CheckForNull
    private static DebtRemediationFunction debtRemediationFunction(RuleDefinitionDto ruleDefinitionDto, RuleMetadataDto ruleMetadataDto) {
        String function = ruleMetadataDto.getRemediationFunction();
        if (function == null || function.isEmpty()) {
            return RuleMapper.defaultDebtRemediationFunction(ruleDefinitionDto);
        }
        return new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.valueOf((String)function.toUpperCase(Locale.ENGLISH)), ruleMetadataDto.getRemediationGapMultiplier(), ruleMetadataDto.getRemediationBaseEffort());
    }

    private static enum RuleParamDtoToWsRuleParam implements Function<RuleParamDto, Rules.Rule.Param>
    {
        INSTANCE;


        public Rules.Rule.Param apply(@Nonnull RuleParamDto param) {
            String defaultValue;
            Rules.Rule.Param.Builder paramResponse = Rules.Rule.Param.newBuilder();
            paramResponse.setKey(param.getName());
            if (param.getDescription() != null) {
                paramResponse.setHtmlDesc(Markdown.convertToHtml((String)param.getDescription()));
            }
            if ((defaultValue = param.getDefaultValue()) != null) {
                paramResponse.setDefaultValue(defaultValue);
            }
            if (param.getType() != null) {
                paramResponse.setType(param.getType());
            }
            return paramResponse.build();
        }
    }
}

