/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.internal.MapSettings;
import org.sonar.server.es.DefaultIndexSettingsElement;
import org.sonar.server.es.IndexDefinition;
import org.sonar.server.es.IndexType;
import org.sonar.server.es.NewIndex;

public class RuleIndexDefinition
implements IndexDefinition {
    private static final String INDEX = "rules";
    public static final IndexType INDEX_TYPE_RULE = new IndexType("rules", "rule");
    public static final String FIELD_RULE_ID = "id";
    public static final String FIELD_RULE_KEY = "key";
    public static final String FIELD_RULE_REPOSITORY = "repo";
    public static final String FIELD_RULE_RULE_KEY = "ruleKey";
    public static final String FIELD_RULE_INTERNAL_KEY = "internalKey";
    public static final String FIELD_RULE_NAME = "name";
    public static final String FIELD_RULE_HTML_DESCRIPTION = "htmlDesc";
    public static final String FIELD_RULE_SEVERITY = "severity";
    public static final String FIELD_RULE_STATUS = "status";
    public static final String FIELD_RULE_LANGUAGE = "lang";
    public static final String FIELD_RULE_IS_TEMPLATE = "isTemplate";
    public static final String FIELD_RULE_IS_EXTERNAL = "isExternal";
    public static final String FIELD_RULE_TEMPLATE_KEY = "templateKey";
    public static final String FIELD_RULE_TYPE = "type";
    public static final String FIELD_RULE_CREATED_AT = "createdAt";
    public static final String FIELD_RULE_UPDATED_AT = "updatedAt";
    public static final Set<String> SORT_FIELDS = ImmutableSet.of((Object)"name", (Object)"updatedAt", (Object)"createdAt", (Object)"key");
    public static final IndexType INDEX_TYPE_RULE_EXTENSION = new IndexType("rules", "ruleExtension");
    public static final String FIELD_RULE_EXTENSION_SCOPE = "scope";
    public static final String FIELD_RULE_EXTENSION_RULE_ID = "ruleId";
    public static final String FIELD_RULE_EXTENSION_TAGS = "tags";
    public static final IndexType INDEX_TYPE_ACTIVE_RULE = new IndexType("rules", "activeRule");
    public static final String FIELD_ACTIVE_RULE_ID = "id";
    public static final String FIELD_ACTIVE_RULE_RULE_ID = "ruleId";
    public static final String FIELD_ACTIVE_RULE_INHERITANCE = "inheritance";
    public static final String FIELD_ACTIVE_RULE_PROFILE_UUID = "ruleProfile";
    public static final String FIELD_ACTIVE_RULE_SEVERITY = "severity";
    private final Configuration config;
    private final boolean enableSource;

    public RuleIndexDefinition(Configuration config) {
        this(config, false);
    }

    private RuleIndexDefinition(Configuration config, boolean enableSource) {
        this.config = config;
        this.enableSource = enableSource;
    }

    public static RuleIndexDefinition createForTest() {
        return new RuleIndexDefinition(new MapSettings().asConfig(), true);
    }

    @Override
    public void define(IndexDefinition.IndexDefinitionContext context) {
        NewIndex index = context.create(INDEX_TYPE_RULE.getIndex(), NewIndex.SettingsConfiguration.newBuilder(this.config).setRefreshInterval(-1).setDefaultNbOfShards(2).build());
        NewIndex.NewIndexType activeRuleMapping = index.createType(INDEX_TYPE_ACTIVE_RULE.getType());
        activeRuleMapping.setEnableSource(this.enableSource);
        activeRuleMapping.setAttribute("_parent", ImmutableMap.of((Object)FIELD_RULE_TYPE, (Object)INDEX_TYPE_RULE.getType()));
        ((NewIndex.KeywordFieldBuilder)activeRuleMapping.keywordFieldBuilder("id").disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)activeRuleMapping.keywordFieldBuilder("ruleId").disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)activeRuleMapping.keywordFieldBuilder(FIELD_ACTIVE_RULE_PROFILE_UUID).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)activeRuleMapping.keywordFieldBuilder(FIELD_ACTIVE_RULE_INHERITANCE).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)activeRuleMapping.keywordFieldBuilder("severity").disableNorms()).build();
        NewIndex.NewIndexType ruleExtensionType = index.createType(INDEX_TYPE_RULE_EXTENSION.getType());
        ruleExtensionType.setEnableSource(this.enableSource);
        ruleExtensionType.setAttribute("_parent", ImmutableMap.of((Object)FIELD_RULE_TYPE, (Object)INDEX_TYPE_RULE.getType()));
        ((NewIndex.KeywordFieldBuilder)ruleExtensionType.keywordFieldBuilder(FIELD_RULE_EXTENSION_SCOPE).disableNorms()).build();
        ruleExtensionType.keywordFieldBuilder(FIELD_RULE_EXTENSION_TAGS).build();
        NewIndex.NewIndexType ruleMapping = index.createType(INDEX_TYPE_RULE.getType());
        ruleMapping.setEnableSource(this.enableSource);
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder("id").disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_KEY).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_RULE_KEY).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER)).build();
        ruleMapping.keywordFieldBuilder(FIELD_RULE_REPOSITORY).build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_INTERNAL_KEY).disableNorms()).disableSearch()).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_NAME).addSubFields(DefaultIndexSettingsElement.SORTABLE_ANALYZER, DefaultIndexSettingsElement.SEARCH_GRAMS_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_HTML_DESCRIPTION).disableSearch()).disableNorms()).disableSortingAndAggregating().addSubFields(DefaultIndexSettingsElement.ENGLISH_HTML_ANALYZER)).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder("severity").disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_STATUS).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_LANGUAGE).disableNorms()).build();
        ruleMapping.createBooleanField(FIELD_RULE_IS_TEMPLATE);
        ruleMapping.createBooleanField(FIELD_RULE_IS_EXTERNAL);
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_TEMPLATE_KEY).disableNorms()).build();
        ((NewIndex.KeywordFieldBuilder)ruleMapping.keywordFieldBuilder(FIELD_RULE_TYPE).disableNorms()).build();
        ruleMapping.createLongField(FIELD_RULE_CREATED_AT);
        ruleMapping.createLongField(FIELD_RULE_UPDATED_AT);
    }
}

