/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.rule.index;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.sonar.db.rule.RuleExtensionForIndexingDto;
import org.sonar.db.rule.RuleForIndexingDto;
import org.sonar.server.es.BaseDoc;
import org.sonar.server.rule.index.RuleExtensionScope;

public class RuleExtensionDoc
extends BaseDoc {
    public RuleExtensionDoc(Map<String, Object> fields) {
        super(fields);
    }

    public RuleExtensionDoc() {
        super(Maps.newHashMapWithExpectedSize((int)4));
    }

    @Override
    public String getId() {
        return RuleExtensionDoc.idOf(this.getRuleId(), this.getScope());
    }

    @Override
    public String getRouting() {
        return this.ruleIdAsString();
    }

    @Override
    public String getParent() {
        return this.ruleIdAsString();
    }

    public int getRuleId() {
        return Integer.valueOf(this.ruleIdAsString());
    }

    private String ruleIdAsString() {
        return (String)this.getField("ruleId");
    }

    public RuleExtensionDoc setRuleId(int ruleId) {
        this.setField("ruleId", String.valueOf(ruleId));
        return this;
    }

    public RuleExtensionScope getScope() {
        return RuleExtensionScope.parse((String)this.getField("scope"));
    }

    public RuleExtensionDoc setScope(RuleExtensionScope scope) {
        this.setField("scope", scope.getScope());
        return this;
    }

    public Set<String> getTags() {
        return (Set)this.getField("tags");
    }

    public RuleExtensionDoc setTags(Set<String> tags) {
        this.setField("tags", tags);
        return this;
    }

    public static RuleExtensionDoc of(RuleForIndexingDto rule) {
        return new RuleExtensionDoc().setRuleId(rule.getId()).setScope(RuleExtensionScope.system()).setTags(rule.getSystemTagsAsSet());
    }

    public static RuleExtensionDoc of(RuleExtensionForIndexingDto rule) {
        return new RuleExtensionDoc().setRuleId(rule.getRuleId()).setScope(RuleExtensionScope.organization(rule.getOrganizationUuid())).setTags(rule.getTagsAsSet());
    }

    public static String idOf(int ruleId, RuleExtensionScope scope) {
        return ruleId + "|" + scope.getScope();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

