/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.protobuf.Message;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.DateUtils;
import org.sonar.core.util.Protobuf;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualityprofile.ActiveRuleCountQuery;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.es.SearchOptions;
import org.sonar.server.qualityprofile.ws.QProfileReference;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.rule.index.RuleIndex;
import org.sonar.server.rule.index.RuleQuery;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Qualityprofiles;

public class ShowAction
implements QProfileWsAction {
    private static final String SONAR_WAY = "Sonar way";
    private static final String SONARQUBE_WAY = "SonarQube way";
    private final DbClient dbClient;
    private final QProfileWsSupport qProfileWsSupport;
    private final Languages languages;
    private final RuleIndex ruleIndex;

    public ShowAction(DbClient dbClient, QProfileWsSupport qProfileWsSupport, Languages languages, RuleIndex ruleIndex) {
        this.dbClient = dbClient;
        this.qProfileWsSupport = qProfileWsSupport;
        this.languages = languages;
        this.ruleIndex = ruleIndex;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction show = controller.createAction("show").setDescription("Show a quality profile").setSince("6.5").setResponseExample(this.getClass().getResource("show-example.json")).setInternal(true).setHandler((RequestHandler)this);
        show.createParam("key").setDescription("Quality profile key").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setDeprecatedKey("profile", "6.6").setRequired(true);
        show.createParam("compareToSonarWay").setDescription("Add the number of missing rules from the related Sonar way profile in the response").setInternal(true).setDefaultValue((Object)"false").setBooleanPossibleValues();
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto profile = this.qProfileWsSupport.getProfile(dbSession, QProfileReference.fromKey(request.mandatoryParam("key")));
            OrganizationDto organization = this.qProfileWsSupport.getOrganization(dbSession, profile);
            boolean isDefault = this.dbClient.defaultQProfileDao().isDefault(dbSession, profile.getOrganizationUuid(), profile.getKee());
            ActiveRuleCountQuery.Builder builder = ActiveRuleCountQuery.builder().setOrganization(organization);
            long activeRuleCount = this.countActiveRulesByQuery(dbSession, profile, builder);
            long deprecatedActiveRuleCount = this.countActiveRulesByQuery(dbSession, profile, builder.setRuleStatus(RuleStatus.DEPRECATED));
            long projectCount = this.countProjectsByOrganizationAndProfiles(dbSession, organization, profile);
            Qualityprofiles.ShowResponse.CompareToSonarWay compareToSonarWay = this.getSonarWay(request, dbSession, organization, profile);
            WsUtils.writeProtobuf((Message)ShowAction.buildResponse(profile, isDefault, this.getLanguage(profile), activeRuleCount, deprecatedActiveRuleCount, projectCount, compareToSonarWay), request, response);
        }
    }

    private long countActiveRulesByQuery(DbSession dbSession, QProfileDto profile, ActiveRuleCountQuery.Builder queryBuilder) {
        Map result = this.dbClient.activeRuleDao().countActiveRulesByQuery(dbSession, queryBuilder.setProfiles(Collections.singletonList(profile)).build());
        return result.getOrDefault(profile.getKee(), 0L);
    }

    private long countProjectsByOrganizationAndProfiles(DbSession dbSession, OrganizationDto organization, QProfileDto profile) {
        Map projects = this.dbClient.qualityProfileDao().countProjectsByOrganizationAndProfiles(dbSession, organization, Collections.singletonList(profile));
        return projects.getOrDefault(profile.getKee(), 0L);
    }

    public Language getLanguage(QProfileDto profile) {
        Language language = this.languages.get(profile.getLanguage());
        WsUtils.checkFound(language, "Quality Profile with key '%s' does not exist", profile.getKee());
        return language;
    }

    @CheckForNull
    public Qualityprofiles.ShowResponse.CompareToSonarWay getSonarWay(Request request, DbSession dbSession, OrganizationDto organization, QProfileDto profile) {
        if (!request.mandatoryParamAsBoolean("compareToSonarWay") || profile.isBuiltIn()) {
            return null;
        }
        QProfileDto sonarWay = Stream.of(SONAR_WAY, SONARQUBE_WAY).map(name -> this.dbClient.qualityProfileDao().selectByNameAndLanguage(dbSession, organization, name, profile.getLanguage())).filter(Objects::nonNull).filter(QProfileDto::isBuiltIn).findFirst().orElse(null);
        if (sonarWay == null) {
            return null;
        }
        long missingRuleCount = this.ruleIndex.search(new RuleQuery().setQProfile(profile).setActivation(false).setCompareToQProfile(sonarWay), new SearchOptions().setLimit(1)).getTotal();
        return Qualityprofiles.ShowResponse.CompareToSonarWay.newBuilder().setProfile(sonarWay.getKee()).setProfileName(sonarWay.getName()).setMissingRuleCount(missingRuleCount).build();
    }

    private static Qualityprofiles.ShowResponse buildResponse(QProfileDto profile, boolean isDefault, Language language, long activeRules, long deprecatedActiveRules, long projects, @Nullable Qualityprofiles.ShowResponse.CompareToSonarWay compareToSonarWay) {
        Qualityprofiles.ShowResponse.Builder showResponseBuilder = Qualityprofiles.ShowResponse.newBuilder();
        Qualityprofiles.ShowResponse.QualityProfile.Builder profileBuilder = Qualityprofiles.ShowResponse.QualityProfile.newBuilder().setKey(profile.getKee()).setName(profile.getName()).setLanguage(profile.getLanguage()).setLanguageName(language.getName()).setIsBuiltIn(profile.isBuiltIn()).setIsDefault(isDefault).setIsInherited(profile.getParentKee() != null).setActiveRuleCount(activeRules).setActiveDeprecatedRuleCount(deprecatedActiveRules).setProjectCount(projects);
        Protobuf.setNullable((Object)profile.getRulesUpdatedAt(), arg_0 -> ((Qualityprofiles.ShowResponse.QualityProfile.Builder)profileBuilder).setRulesUpdatedAt(arg_0));
        Protobuf.setNullable((Object)profile.getLastUsed(), last -> profileBuilder.setLastUsed(DateUtils.formatDateTime((long)last)));
        Protobuf.setNullable((Object)profile.getUserUpdatedAt(), userUpdatedAt -> profileBuilder.setUserUpdatedAt(DateUtils.formatDateTime((long)userUpdatedAt)));
        Protobuf.setNullable((Object)compareToSonarWay, arg_0 -> ((Qualityprofiles.ShowResponse.Builder)showResponseBuilder).setCompareToSonarWay(arg_0));
        return showResponseBuilder.setProfile(profileBuilder).build();
    }
}

