/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.server.qualityprofile.BulkChangeResult;
import org.sonar.server.qualityprofile.QProfileBackuper;
import org.sonar.server.qualityprofile.QProfileRestoreSummary;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;
import org.sonar.server.user.UserSession;

public class RestoreAction
implements QProfileWsAction {
    private final DbClient dbClient;
    private final QProfileBackuper backuper;
    private final Languages languages;
    private final UserSession userSession;
    private final QProfileWsSupport wsSupport;

    public RestoreAction(DbClient dbClient, QProfileBackuper backuper, Languages languages, UserSession userSession, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.backuper = backuper;
        this.languages = languages;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController controller) {
        WebService.NewAction action = controller.createAction("restore").setSince("5.2").setDescription("Restore a quality profile using an XML file. The restored profile name is taken from the backup file, so if a profile with the same name and language already exists, it will be overwritten.<br> Requires to be logged in and the 'Administer Quality Profiles' permission.").setPost(true).setHandler((RequestHandler)this);
        action.createParam("backup").setDescription("A profile backup file in XML format, as generated by api/qualityprofiles/backup or the former api/profiles/backup.").setRequired(true);
        QProfileWsSupport.createOrganizationParam(action).setSince("6.4");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request request, Response response) throws Exception {
        this.userSession.checkLoggedIn();
        InputStream backup = request.paramAsInputStream("backup");
        Preconditions.checkArgument((backup != null ? 1 : 0) != 0, (Object)"A backup file must be provided");
        String organizationKey = request.param("organization");
        InputStreamReader reader = null;
        try (DbSession dbSession = this.dbClient.openSession(false);){
            reader = new InputStreamReader(backup, StandardCharsets.UTF_8);
            OrganizationDto organization = this.wsSupport.getOrganizationByKey(dbSession, organizationKey);
            this.userSession.checkPermission(OrganizationPermission.ADMINISTER_QUALITY_PROFILES, organization);
            QProfileRestoreSummary summary = this.backuper.restore(dbSession, reader, organization, null);
            this.writeResponse(response.newJsonWriter(), organization, summary);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly((InputStream)backup);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((InputStream)backup);
    }

    private void writeResponse(JsonWriter json, OrganizationDto organization, QProfileRestoreSummary summary) {
        QProfileDto profile = summary.getProfile();
        String languageKey = profile.getLanguage();
        Language language = this.languages.get(languageKey);
        JsonWriter jsonProfile = json.beginObject().name("profile").beginObject();
        jsonProfile.prop("organization", organization.getKey()).prop("key", profile.getKee()).prop("name", profile.getName()).prop("language", languageKey).prop("isDefault", false).prop("isInherited", false);
        if (language != null) {
            jsonProfile.prop("languageName", language.getName());
        }
        jsonProfile.endObject();
        BulkChangeResult ruleChanges = summary.getRuleChanges();
        json.prop("ruleSuccesses", (long)ruleChanges.countSucceeded());
        json.prop("ruleFailures", (long)ruleChanges.countFailed());
        json.endObject().close();
    }
}

