/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualitygate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.picocontainer.Startable;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.core.util.UuidFactory;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.qualitygate.QualityGateConditionDao;
import org.sonar.db.qualitygate.QualityGateConditionDto;
import org.sonar.db.qualitygate.QualityGateDao;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.computation.task.projectanalysis.qualitymodel.Rating;
import org.sonar.server.qualitygate.QualityGateConditionsUpdater;

public class RegisterQualityGates
implements Startable {
    private static final Logger LOGGER = Loggers.get(RegisterQualityGates.class);
    private static final String BUILTIN_QUALITY_GATE_NAME = "Sonar way";
    private static final int LEAK_PERIOD = 1;
    private static final String A_RATING = Integer.toString(Rating.A.getIndex());
    private static final List<QualityGateCondition> QUALITY_GATE_CONDITIONS = Arrays.asList(new QualityGateCondition().setMetricKey("new_security_rating").setOperator("GT").setPeriod(1).setErrorThreshold(A_RATING), new QualityGateCondition().setMetricKey("new_reliability_rating").setOperator("GT").setPeriod(1).setErrorThreshold(A_RATING), new QualityGateCondition().setMetricKey("new_maintainability_rating").setOperator("GT").setPeriod(1).setErrorThreshold(A_RATING), new QualityGateCondition().setMetricKey("new_coverage").setOperator("LT").setPeriod(1).setErrorThreshold("80"), new QualityGateCondition().setMetricKey("new_duplicated_lines_density").setOperator("GT").setPeriod(1).setErrorThreshold("3"));
    private final DbClient dbClient;
    private final QualityGateConditionsUpdater qualityGateConditionsUpdater;
    private final QualityGateDao qualityGateDao;
    private final QualityGateConditionDao qualityGateConditionDao;
    private final UuidFactory uuidFactory;
    private final System2 system2;

    public RegisterQualityGates(DbClient dbClient, QualityGateConditionsUpdater qualityGateConditionsUpdater, UuidFactory uuidFactory, System2 system2) {
        this.dbClient = dbClient;
        this.qualityGateConditionsUpdater = qualityGateConditionsUpdater;
        this.qualityGateDao = dbClient.qualityGateDao();
        this.qualityGateConditionDao = dbClient.gateConditionDao();
        this.uuidFactory = uuidFactory;
        this.system2 = system2;
    }

    public void start() {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QualityGateDto builtin = this.qualityGateDao.selectByName(dbSession, BUILTIN_QUALITY_GATE_NAME);
            if (builtin == null) {
                LOGGER.info("Built-in quality gate [{}] has been created", (Object)BUILTIN_QUALITY_GATE_NAME);
                builtin = this.createQualityGate(dbSession, BUILTIN_QUALITY_GATE_NAME);
            }
            if (!builtin.isBuiltIn()) {
                builtin.setBuiltIn(true);
                this.dbClient.qualityGateDao().update(builtin, dbSession);
                LOGGER.info("Quality gate [{}] has been set as built-in", (Object)BUILTIN_QUALITY_GATE_NAME);
            }
            this.updateQualityConditionsIfRequired(dbSession, builtin);
            this.qualityGateDao.ensureOneBuiltInQualityGate(dbSession, BUILTIN_QUALITY_GATE_NAME);
            dbSession.commit();
        }
    }

    private void updateQualityConditionsIfRequired(DbSession dbSession, QualityGateDto builtin) {
        Map<Long, String> idToKeyMetric = this.dbClient.metricDao().selectAll(dbSession).stream().collect(Collectors.toMap(metricDto -> metricDto.getId().longValue(), MetricDto::getKey));
        List qualityGateConditions = (List)this.qualityGateConditionDao.selectForQualityGate(dbSession, builtin.getId().longValue()).stream().map(dto -> QualityGateCondition.from(dto, idToKeyMetric)).collect(MoreCollectors.toList());
        ArrayList qgConditionsToBeDeleted = new ArrayList(qualityGateConditions);
        qgConditionsToBeDeleted.removeAll(QUALITY_GATE_CONDITIONS);
        qgConditionsToBeDeleted.stream().forEach(qgc -> this.qualityGateConditionDao.delete(qgc.toQualityGateDto(builtin.getId()), dbSession));
        ArrayList<QualityGateCondition> qgConditionsToBeCreated = new ArrayList<QualityGateCondition>(QUALITY_GATE_CONDITIONS);
        qgConditionsToBeCreated.removeAll(qualityGateConditions);
        qgConditionsToBeCreated.stream().forEach(qgc -> this.qualityGateConditionsUpdater.createCondition(dbSession, builtin, qgc.getMetricKey(), qgc.getOperator(), qgc.getWarningThreshold(), qgc.getErrorThreshold(), qgc.getPeriod()));
        if (!qgConditionsToBeCreated.isEmpty() || !qgConditionsToBeDeleted.isEmpty()) {
            LOGGER.info("Built-in quality gate's conditions of [{}] has been updated", (Object)BUILTIN_QUALITY_GATE_NAME);
        }
    }

    public void stop() {
    }

    private QualityGateDto createQualityGate(DbSession dbSession, String name) {
        QualityGateDto qualityGate = new QualityGateDto().setName(name).setBuiltIn(true).setUuid(this.uuidFactory.create()).setCreatedAt(new Date(this.system2.now()));
        return this.dbClient.qualityGateDao().insert(dbSession, qualityGate);
    }

    private static class QualityGateCondition {
        private Long id;
        private String metricKey;
        private Integer period;
        private String operator;
        private String warningThreshold;
        private String errorThreshold;

        private QualityGateCondition() {
        }

        public static QualityGateCondition from(QualityGateConditionDto qualityGateConditionDto, Map<Long, String> mapping) {
            return new QualityGateCondition().setId(qualityGateConditionDto.getId()).setMetricKey(mapping.get(qualityGateConditionDto.getMetricId())).setOperator(qualityGateConditionDto.getOperator()).setPeriod(qualityGateConditionDto.getPeriod()).setErrorThreshold(qualityGateConditionDto.getErrorThreshold()).setWarningThreshold(qualityGateConditionDto.getWarningThreshold());
        }

        @CheckForNull
        public Long getId() {
            return this.id;
        }

        public QualityGateCondition setId(Long id) {
            this.id = id;
            return this;
        }

        public String getMetricKey() {
            return this.metricKey;
        }

        public QualityGateCondition setMetricKey(String metricKey) {
            this.metricKey = metricKey;
            return this;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public QualityGateCondition setPeriod(Integer period) {
            this.period = period;
            return this;
        }

        public String getOperator() {
            return this.operator;
        }

        public QualityGateCondition setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        @CheckForNull
        public String getWarningThreshold() {
            return this.warningThreshold;
        }

        public QualityGateCondition setWarningThreshold(@Nullable String warningThreshold) {
            this.warningThreshold = warningThreshold;
            return this;
        }

        @CheckForNull
        public String getErrorThreshold() {
            return this.errorThreshold;
        }

        public QualityGateCondition setErrorThreshold(@Nullable String errorThreshold) {
            this.errorThreshold = errorThreshold;
            return this;
        }

        public QualityGateConditionDto toQualityGateDto(long qualityGateId) {
            return new QualityGateConditionDto().setId(this.id.longValue()).setMetricKey(this.metricKey).setOperator(this.operator).setPeriod(this.period).setErrorThreshold(this.errorThreshold).setWarningThreshold(this.warningThreshold).setQualityGateId(qualityGateId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QualityGateCondition that = (QualityGateCondition)o;
            return Objects.equals(this.metricKey, that.metricKey) && Objects.equals(this.period, that.period) && Objects.equals(this.operator, that.operator) && Objects.equals(this.warningThreshold, that.warningThreshold) && Objects.equals(this.errorThreshold, that.errorThreshold);
        }

        public int hashCode() {
            return Objects.hash(this.metricKey, this.period, this.operator, this.warningThreshold, this.errorThreshold);
        }
    }
}

