/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.property;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.property.InternalProperties;

public class InternalPropertiesImpl
implements InternalProperties {
    private final DbClient dbClient;

    public InternalPropertiesImpl(DbClient dbClient) {
        this.dbClient = dbClient;
    }

    @Override
    public Optional<String> read(String propertyKey) {
        InternalPropertiesImpl.checkPropertyKey(propertyKey);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Optional optional = this.dbClient.internalPropertiesDao().selectByKey(dbSession, propertyKey);
            return optional;
        }
    }

    @Override
    public void write(String propertyKey, @Nullable String value) {
        InternalPropertiesImpl.checkPropertyKey(propertyKey);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            if (value == null || value.isEmpty()) {
                this.dbClient.internalPropertiesDao().saveAsEmpty(dbSession, propertyKey);
            } else {
                this.dbClient.internalPropertiesDao().save(dbSession, propertyKey, value);
            }
            dbSession.commit();
        }
    }

    private static void checkPropertyKey(@Nullable String propertyKey) {
        Preconditions.checkArgument((propertyKey != null && !propertyKey.isEmpty() ? 1 : 0) != 0, (Object)"property key can't be null nor empty");
    }
}

