/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.projectanalysis.ws.SearchRequest;

class SearchData {
    final List<SnapshotDto> analyses;
    final ListMultimap<String, EventDto> eventsByAnalysis;
    final Paging paging;

    private SearchData(Builder builder) {
        this.analyses = builder.analyses;
        this.eventsByAnalysis = SearchData.buildEvents(builder.events);
        this.paging = Paging.forPageIndex((int)builder.getRequest().getPage()).withPageSize(builder.getRequest().getPageSize()).andTotal(builder.countAnalyses);
    }

    private static ListMultimap<String, EventDto> buildEvents(List<EventDto> events) {
        return (ListMultimap)events.stream().collect(MoreCollectors.index(EventDto::getAnalysisUuid));
    }

    static Builder builder(DbSession dbSession, SearchRequest request) {
        return new Builder(dbSession, request);
    }

    static class Builder {
        private final DbSession dbSession;
        private final SearchRequest request;
        private ComponentDto project;
        private List<SnapshotDto> analyses;
        private int countAnalyses;
        private List<EventDto> events;

        private Builder(DbSession dbSession, SearchRequest request) {
            this.dbSession = dbSession;
            this.request = request;
        }

        Builder setProject(ComponentDto project) {
            this.project = project;
            return this;
        }

        Builder setAnalyses(List<SnapshotDto> analyses) {
            Stream stream = analyses.stream();
            if (this.request.getCategory() == null) {
                stream = stream.skip(Paging.offset((int)this.request.getPage(), (int)this.request.getPageSize())).limit(this.request.getPageSize());
            }
            this.analyses = (List)stream.collect(MoreCollectors.toList());
            this.countAnalyses = analyses.size();
            return this;
        }

        Builder setEvents(List<EventDto> events) {
            this.events = events;
            return this;
        }

        DbSession getDbSession() {
            return this.dbSession;
        }

        SearchRequest getRequest() {
            return this.request;
        }

        ComponentDto getProject() {
            return this.project;
        }

        List<SnapshotDto> getAnalyses() {
            return this.analyses;
        }

        private void filterByCategory() {
            ListMultimap eventCategoriesByAnalysisUuid = (ListMultimap)this.events.stream().collect(MoreCollectors.index(EventDto::getAnalysisUuid, EventDto::getCategory));
            Predicate<SnapshotDto> byCategory = a -> eventCategoriesByAnalysisUuid.get((Object)a.getUuid()).contains(this.request.getCategory().getLabel());
            this.countAnalyses = (int)this.analyses.stream().filter(byCategory).count();
            this.analyses = (List)this.analyses.stream().filter(byCategory).skip(Paging.offset((int)this.request.getPage(), (int)this.request.getPageSize())).limit(this.request.getPageSize()).collect(MoreCollectors.toList());
        }

        SearchData build() {
            Objects.requireNonNull(this.analyses);
            Objects.requireNonNull(this.events);
            if (this.request.getCategory() != null) {
                this.filterByCategory();
            }
            return new SearchData(this);
        }
    }
}

