/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.projectanalysis.ws;

import com.google.common.base.Preconditions;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.SnapshotDto;
import org.sonar.db.event.EventDto;
import org.sonar.server.exceptions.NotFoundException;
import org.sonar.server.projectanalysis.ws.EventCategory;
import org.sonar.server.projectanalysis.ws.EventValidator;
import org.sonar.server.projectanalysis.ws.ProjectAnalysesWsAction;
import org.sonar.server.user.UserSession;

public class DeleteEventAction
implements ProjectAnalysesWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteEventAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("delete_event").setDescription("Delete a project analysis event.<br>Only event of category '%s' and '%s' can be deleted.<br>Requires one of the following permissions:<ul>  <li>'Administer System'</li>  <li>'Administer' rights on the specified project</li></ul>", new Object[]{EventCategory.VERSION.name(), EventCategory.OTHER.name()}).setPost(true).setSince("6.3").setHandler((RequestHandler)this);
        action.createParam("event").setDescription("Event key").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        String eventP = request.mandatoryParam("event");
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Stream.of(this.getEvent(dbSession, eventP)).peek(this.checkPermissions()).peek(EventValidator.checkModifiable()).forEach(event -> this.deleteEvent(dbSession, (EventDto)event));
        }
        response.noContent();
    }

    private EventDto getEvent(DbSession dbSession, String event) {
        return (EventDto)this.dbClient.eventDao().selectByUuid(dbSession, event).orElseThrow(() -> new NotFoundException(String.format("Event '%s' not found", event)));
    }

    private void deleteEvent(DbSession dbSession, EventDto dbEvent) {
        if (EventCategory.VERSION.getLabel().equals(dbEvent.getCategory())) {
            SnapshotDto analysis = (SnapshotDto)this.dbClient.snapshotDao().selectByUuid(dbSession, dbEvent.getAnalysisUuid()).orElseThrow(() -> new IllegalStateException(String.format("Analysis '%s' not found", dbEvent.getAnalysisUuid())));
            Preconditions.checkArgument((analysis.getLast() == false ? 1 : 0) != 0, (Object)"Cannot delete the version event of last analysis");
            analysis.setVersion(null);
            this.dbClient.snapshotDao().update(dbSession, analysis);
        }
        this.dbClient.eventDao().delete(dbSession, dbEvent.getUuid());
        dbSession.commit();
    }

    private Consumer<EventDto> checkPermissions() {
        return event -> this.userSession.checkComponentUuidPermission("admin", event.getComponentUuid());
    }
}

