/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.project.ws;

import com.google.common.io.Resources;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.server.project.ws.ProjectsWsAction;
import org.sonar.server.user.UserSession;

public class IndexAction
implements ProjectsWsAction {
    private static final String PARAM_PROJECT = "project";
    private static final String PARAM_SEARCH = "search";
    private static final String PARAM_SUB_PROJECTS = "subprojects";
    private static final String PARAM_FORMAT = "format";
    private final DbClient dbClient;
    private final UserSession userSession;

    public IndexAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("index").setDescription("This web service is deprecated, please use api/components/search instead").setSince("2.10").setDeprecatedSince("6.3").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"index-example.json"));
        action.setChangelog(new Change[]{new Change("6.3", "The parameters 'desc', 'views', 'libs' and 'versions' have no effect.")});
        action.createParam(PARAM_PROJECT).setDescription("key or ID of the project").setDeprecatedKey("key", "6.4").setExampleValue((Object)"my_project");
        action.createParam(PARAM_SEARCH).setDescription("Substring of project name, case insensitive. Ignored if the parameter key is set").setExampleValue((Object)"Sonar");
        action.createParam(PARAM_SUB_PROJECTS).setDescription("Load sub-projects. Ignored if the parameter key is set").setDefaultValue((Object)"false").setBooleanPossibleValues();
        action.createParam(PARAM_FORMAT).setDescription("Only json response format is available").setPossibleValues(new Object[]{"json"});
        IndexAction.addRemovedParameter("desc", action);
        IndexAction.addRemovedParameter("views", action);
        IndexAction.addRemovedParameter("libs", action);
        IndexAction.addRemovedParameter("versions", action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            List projects = (List)this.getAuthorizedComponents(this.searchComponents(dbSession, request)).stream().filter(p -> p.getMainBranchProjectUuid() == null).collect(MoreCollectors.toList());
            JsonWriter json = response.newJsonWriter();
            json.beginArray();
            for (ComponentDto project : projects) {
                IndexAction.addProject(json, project);
            }
            json.endArray();
            json.close();
        }
    }

    private List<ComponentDto> searchComponents(DbSession dbSession, Request request) {
        String projectKey = request.param(PARAM_PROJECT);
        ArrayList<ComponentDto> projects = new ArrayList<ComponentDto>();
        if (projectKey != null) {
            this.getProjectByKeyOrId(dbSession, projectKey).ifPresent(projects::add);
        } else {
            String nameQuery = request.param(PARAM_SEARCH);
            boolean includeModules = request.paramAsBoolean(PARAM_SUB_PROJECTS);
            projects.addAll(this.dbClient.componentDao().selectProjectsByNameQuery(dbSession, nameQuery, includeModules));
        }
        return projects;
    }

    private Optional<ComponentDto> getProjectByKeyOrId(DbSession dbSession, String component) {
        try {
            Long componentId = Long.parseLong(component);
            return Optional.ofNullable(this.dbClient.componentDao().selectById(dbSession, componentId.longValue()).orNull());
        }
        catch (NumberFormatException e) {
            return Optional.ofNullable(this.dbClient.componentDao().selectByKey(dbSession, component).orNull());
        }
    }

    private List<ComponentDto> getAuthorizedComponents(List<ComponentDto> components) {
        return this.userSession.keepAuthorizedComponents("user", components);
    }

    private static void addProject(JsonWriter json, ComponentDto project) {
        json.beginObject().prop("id", (Number)project.getId()).prop("k", project.getDbKey()).prop("nm", project.name()).prop("sc", project.scope()).prop("qu", project.qualifier()).endObject();
    }

    private static void addRemovedParameter(String key, WebService.NewAction action) {
        action.createParam(key).setDescription("Since 6.3, this parameter has no effect").setDeprecatedSince("6.3");
    }
}

