/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import com.google.common.base.Preconditions;
import com.google.common.io.Resources;
import java.util.Optional;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.Database;
import org.sonar.server.platform.db.migration.DatabaseMigrationState;
import org.sonar.server.platform.db.migration.version.DatabaseVersion;
import org.sonar.server.platform.ws.DbMigrationJsonWriter;
import org.sonar.server.platform.ws.SystemWsAction;

public class DbMigrationStatusAction
implements SystemWsAction {
    private final DatabaseVersion databaseVersion;
    private final DatabaseMigrationState databaseMigrationState;
    private final Database database;

    public DbMigrationStatusAction(DatabaseVersion databaseVersion, Database database, DatabaseMigrationState databaseMigrationState) {
        this.databaseVersion = databaseVersion;
        this.database = database;
        this.databaseMigrationState = databaseMigrationState;
    }

    public void define(WebService.NewController controller) {
        controller.createAction("db_migration_status").setDescription("Display the database migration status of SonarQube.<br/>" + DbMigrationJsonWriter.statusDescription()).setSince("5.2").setHandler((RequestHandler)this).setResponseExample(Resources.getResource(this.getClass(), (String)"example-migrate_db.json"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handle(Request request, Response response) throws Exception {
        Optional currentVersion = this.databaseVersion.getVersion();
        Preconditions.checkState((boolean)currentVersion.isPresent(), (Object)"Cannot connect to Database.");
        try (JsonWriter json = response.newJsonWriter();){
            DatabaseVersion.Status status = this.databaseVersion.getStatus();
            if (status == DatabaseVersion.Status.UP_TO_DATE || status == DatabaseVersion.Status.REQUIRES_DOWNGRADE) {
                DbMigrationJsonWriter.write(json, this.databaseMigrationState);
                return;
            }
            if (!this.database.getDialect().supportsMigration()) {
                DbMigrationJsonWriter.writeNotSupportedResponse(json);
                return;
            }
            switch (this.databaseMigrationState.getStatus()) {
                case RUNNING: 
                case FAILED: 
                case SUCCEEDED: {
                    DbMigrationJsonWriter.write(json, this.databaseMigrationState);
                    return;
                }
                case NONE: {
                    DbMigrationJsonWriter.writeMigrationRequiredResponse(json);
                    return;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported DatabaseMigration status");
                }
            }
        }
    }
}

