/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform.ws;

import java.util.Collection;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.server.health.ClusterHealth;
import org.sonar.server.health.HealthChecker;
import org.sonar.server.platform.monitoring.cluster.AppNodesInfoLoader;
import org.sonar.server.platform.monitoring.cluster.GlobalInfoLoader;
import org.sonar.server.platform.monitoring.cluster.NodeInfo;
import org.sonar.server.platform.monitoring.cluster.SearchNodesInfoLoader;
import org.sonar.server.platform.ws.SystemInfoWriter;
import org.sonar.server.telemetry.TelemetryDataLoader;

public class ClusterSystemInfoWriter
extends SystemInfoWriter {
    private final GlobalInfoLoader globalInfoLoader;
    private final AppNodesInfoLoader appNodesInfoLoader;
    private final SearchNodesInfoLoader searchNodesInfoLoader;
    private final HealthChecker healthChecker;

    public ClusterSystemInfoWriter(GlobalInfoLoader globalInfoLoader, AppNodesInfoLoader appNodesInfoLoader, SearchNodesInfoLoader searchNodesInfoLoader, HealthChecker healthChecker, TelemetryDataLoader telemetry) {
        super(telemetry);
        this.globalInfoLoader = globalInfoLoader;
        this.appNodesInfoLoader = appNodesInfoLoader;
        this.searchNodesInfoLoader = searchNodesInfoLoader;
        this.healthChecker = healthChecker;
    }

    @Override
    public void write(JsonWriter json) throws InterruptedException {
        ClusterHealth clusterHealth = this.healthChecker.checkCluster();
        this.writeHealth(clusterHealth.getHealth(), json);
        this.writeGlobalSections(json);
        this.writeApplicationNodes(json, clusterHealth);
        this.writeSearchNodes(json, clusterHealth);
        this.writeTelemetry(json);
    }

    private void writeGlobalSections(JsonWriter json) {
        this.writeSections(this.globalInfoLoader.load(), json);
    }

    private void writeApplicationNodes(JsonWriter json, ClusterHealth clusterHealth) throws InterruptedException {
        json.name("Application Nodes").beginArray();
        Collection<NodeInfo> appNodes = this.appNodesInfoLoader.load();
        for (NodeInfo applicationNode : appNodes) {
            this.writeNodeInfo(applicationNode, clusterHealth, json);
        }
        json.endArray();
    }

    private void writeSearchNodes(JsonWriter json, ClusterHealth clusterHealth) {
        json.name("Search Nodes").beginArray();
        Collection<NodeInfo> searchNodes = this.searchNodesInfoLoader.load();
        searchNodes.forEach(node -> this.writeNodeInfo((NodeInfo)node, clusterHealth, json));
        json.endArray();
    }

    private void writeNodeInfo(NodeInfo nodeInfo, ClusterHealth clusterHealth, JsonWriter json) {
        json.beginObject();
        json.prop("Name", nodeInfo.getName());
        json.prop("Error", (String)nodeInfo.getErrorMessage().orElse(null));
        json.prop("Host", (String)nodeInfo.getHost().orElse(null));
        json.prop("Started At", (Number)nodeInfo.getStartedAt().orElse(null));
        clusterHealth.getNodeHealth(nodeInfo.getName()).ifPresent(h -> {
            json.prop("Health", h.getStatus().name());
            json.name("Health Causes").beginArray().values((Iterable)h.getCauses()).endArray();
        });
        this.writeSections(nodeInfo.getSections(), json);
        json.endObject();
    }
}

