/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import java.io.File;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.process.ProcessProperties;
import org.sonar.server.platform.ServerFileSystem;

public class ServerFileSystemImpl
implements ServerFileSystem,
org.sonar.api.platform.ServerFileSystem,
Startable {
    private static final Logger LOGGER = Loggers.get(ServerFileSystemImpl.class);
    private final File homeDir;
    private final File tempDir;
    private final File deployDir;
    private final File uninstallDir;

    public ServerFileSystemImpl(Configuration config) {
        this.homeDir = new File((String)config.get(ProcessProperties.Property.PATH_HOME.getKey()).get());
        this.tempDir = new File((String)config.get(ProcessProperties.Property.PATH_TEMP.getKey()).get());
        File dataDir = new File((String)config.get(ProcessProperties.Property.PATH_DATA.getKey()).get());
        this.deployDir = new File(dataDir, "web/deploy");
        this.uninstallDir = new File(this.getTempDir(), "uninstalled-plugins");
    }

    public void start() {
        LOGGER.info("SonarQube home: " + this.homeDir.getAbsolutePath());
    }

    public void stop() {
    }

    @Override
    public File getHomeDir() {
        return this.homeDir;
    }

    @Override
    public File getTempDir() {
        return this.tempDir;
    }

    @Override
    public File getDeployedPluginsDir() {
        return new File(this.deployDir, "plugins");
    }

    @Override
    public File getDownloadedPluginsDir() {
        return new File(this.getHomeDir(), "extensions/downloads");
    }

    @Override
    public File getInstalledPluginsDir() {
        return new File(this.getHomeDir(), "extensions/plugins");
    }

    @Override
    public File getPluginIndex() {
        return new File(this.deployDir, "plugins/index.txt");
    }

    @Override
    public File getUninstalledPluginsDir() {
        return this.uninstallDir;
    }
}

