/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.platform;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.config.Settings;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.property.PropertyDto;
import org.sonar.server.platform.SettingsChangeNotifier;

public class PersistentSettings {
    private final Settings delegate;
    private final DbClient dbClient;
    private final SettingsChangeNotifier changeNotifier;

    public PersistentSettings(Settings delegate, DbClient dbClient, SettingsChangeNotifier changeNotifier) {
        this.delegate = delegate;
        this.dbClient = dbClient;
        this.changeNotifier = changeNotifier;
    }

    @CheckForNull
    public String getString(String key) {
        return this.delegate.getString(key);
    }

    public PersistentSettings saveProperty(DbSession dbSession, String key, @Nullable String value) {
        this.savePropertyImpl(dbSession, key, value);
        this.changeNotifier.onGlobalPropertyChange(key, value);
        return this;
    }

    public PersistentSettings saveProperty(String key, @Nullable String value) {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            this.savePropertyImpl(dbSession, key, value);
            dbSession.commit();
            this.changeNotifier.onGlobalPropertyChange(key, value);
            PersistentSettings persistentSettings = this;
            return persistentSettings;
        }
    }

    private void savePropertyImpl(DbSession dbSession, String key, @Nullable String value) {
        if (value == null) {
            this.dbClient.propertiesDao().deleteGlobalProperty(key, dbSession);
        } else {
            this.dbClient.propertiesDao().saveProperty(dbSession, new PropertyDto().setKey(key).setValue(value));
        }
        this.delegate.setProperty(key, value);
    }

    public Settings getSettings() {
        return this.delegate;
    }
}

