/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.permission.template.PermissionTemplateDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.PermissionsWsParametersBuilder;
import org.sonar.server.permission.ws.template.WsTemplateRef;
import org.sonar.server.user.UserSession;
import org.sonar.server.usergroups.ws.GroupIdOrAnyone;

public class RemoveGroupFromTemplateAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final PermissionWsSupport wsSupport;
    private final UserSession userSession;

    public RemoveGroupFromTemplateAction(DbClient dbClient, PermissionWsSupport wsSupport, UserSession userSession) {
        this.dbClient = dbClient;
        this.wsSupport = wsSupport;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("remove_group_from_template").setPost(true).setSince("5.2").setDescription("Remove a group from a permission template.<br /> The group id or group name must be provided. <br />Requires the following permission: 'Administer System'.").setHandler((RequestHandler)this);
        PermissionsWsParametersBuilder.createTemplateParameters(action);
        PermissionsWsParametersBuilder.createProjectPermissionParameter(action);
        PermissionsWsParametersBuilder.createGroupIdParameter(action);
        PermissionsWsParametersBuilder.createGroupNameParameter(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            String permission = request.mandatoryParam("permission");
            PermissionTemplateDto template = this.wsSupport.findTemplate(dbSession, WsTemplateRef.fromRequest(request));
            PermissionPrivilegeChecker.checkGlobalAdmin(this.userSession, template.getOrganizationUuid());
            GroupIdOrAnyone groupId = this.wsSupport.findGroup(dbSession, request);
            Preconditions.checkArgument((boolean)groupId.getOrganizationUuid().equals(template.getOrganizationUuid()), (Object)"Group and template are on different organizations");
            this.dbClient.permissionTemplateDao().deleteGroupPermission(dbSession, template.getId(), groupId.getId(), permission);
            dbSession.commit();
        }
        response.noContent();
    }
}

