/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws.template;

import java.util.Optional;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.db.organization.DefaultTemplates;
import org.sonar.server.permission.ws.template.DefaultTemplatesResolver;

public class DefaultTemplatesResolverImpl
implements DefaultTemplatesResolver {
    private final ResourceTypes resourceTypes;

    public DefaultTemplatesResolverImpl(ResourceTypes resourceTypes) {
        this.resourceTypes = resourceTypes;
    }

    @Override
    public DefaultTemplatesResolver.ResolvedDefaultTemplates resolve(DefaultTemplates defaultTemplates) {
        String projectDefaultTemplate = defaultTemplates.getProjectUuid();
        return new DefaultTemplatesResolver.ResolvedDefaultTemplates(projectDefaultTemplate, DefaultTemplatesResolverImpl.isViewsEnabled(this.resourceTypes) ? Optional.ofNullable(defaultTemplates.getViewUuid()).orElse(projectDefaultTemplate) : null);
    }

    private static boolean isViewsEnabled(ResourceTypes resourceTypes) {
        return resourceTypes.getRoots().stream().map(ResourceType::getQualifier).anyMatch("VW"::equals);
    }
}

