/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.core.permission.GlobalPermissions;
import org.sonar.core.permission.ProjectPermissions;
import org.sonar.server.exceptions.BadRequestException;
import org.sonar.server.usergroups.ws.GroupIdOrAnyone;
import org.sonar.server.ws.WsUtils;

public class PermissionRequestValidator {
    public static final String MSG_TEMPLATE_WITH_SAME_NAME = "A template with the name '%s' already exists (case insensitive).";
    public static final String MSG_TEMPLATE_NAME_NOT_BLANK = "The template name must not be blank";

    private PermissionRequestValidator() {
    }

    public static String validateProjectPermission(String permission) {
        WsUtils.checkRequest(ProjectPermissions.ALL.contains(permission), String.format("The '%s' parameter for project permissions must be one of %s. '%s' was passed.", "permission", ProjectPermissions.ALL_ON_ONE_LINE, permission), new Object[0]);
        return permission;
    }

    public static void validateGlobalPermission(String permission) {
        WsUtils.checkRequest(GlobalPermissions.ALL.contains(permission), String.format("The '%s' parameter for global permissions must be one of %s. '%s' was passed.", "permission", GlobalPermissions.ALL_ON_ONE_LINE, permission), new Object[0]);
    }

    public static void validateNotAnyoneAndAdminPermission(String permission, GroupIdOrAnyone group) {
        WsUtils.checkRequest(!"admin".equals(permission) || !group.isAnyone(), String.format("It is not possible to add the '%s' permission to group 'Anyone'.", permission), new Object[0]);
    }

    public static void validateTemplateNameFormat(String name) {
        WsUtils.checkRequest(!StringUtils.isBlank((String)name), MSG_TEMPLATE_NAME_NOT_BLANK, new Object[0]);
    }

    public static void validateQualifier(String qualifier, Set<String> rootQualifiers) {
        WsUtils.checkRequest(rootQualifiers.contains(qualifier), String.format("The '%s' parameter must be one of %s. '%s' was passed.", "qualifier", rootQualifiers, qualifier), new Object[0]);
    }

    public static void validateQualifier(@Nullable String qualifier, ResourceTypes resourceTypes) {
        if (qualifier == null) {
            return;
        }
        ImmutableSet rootQualifiers = FluentIterable.from((Iterable)resourceTypes.getRoots()).transform(ResourceType::getQualifier).toSet();
        WsUtils.checkRequest(rootQualifiers.contains(qualifier), String.format("The '%s' parameter must be one of %s. '%s' was passed.", "qualifier", rootQualifiers, qualifier), new Object[0]);
    }

    public static void validateProjectPattern(@Nullable String projectPattern) {
        if (Strings.isNullOrEmpty((String)projectPattern)) {
            return;
        }
        try {
            Pattern.compile(projectPattern);
        }
        catch (PatternSyntaxException e) {
            throw BadRequestException.create(String.format("The '%s' parameter must be a valid Java regular expression. '%s' was passed", "projectKeyPattern", projectPattern));
        }
    }
}

