/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.organization.ws;

import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.Pagination;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.organization.OrganizationQuery;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.organization.ws.OrganizationsWsAction;
import org.sonar.server.organization.ws.OrganizationsWsSupport;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Common;
import org.sonarqube.ws.Organizations;

public class SearchAction
implements OrganizationsWsAction {
    static final String PARAM_ORGANIZATIONS = "organizations";
    static final String PARAM_MEMBER = "member";
    private static final String ACTION = "search";
    private static final int MAX_SIZE = 500;
    private final DbClient dbClient;
    private final UserSession userSession;
    private final OrganizationsWsSupport wsSupport;

    public SearchAction(DbClient dbClient, UserSession userSession, OrganizationsWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(false).setDescription("Search for organizations").setResponseExample(this.getClass().getResource("search-example.json")).setInternal(true).setSince("6.2").setChangelog(new Change[]{new Change("6.4", "Paging fields have been added to the response")}).setHandler((RequestHandler)this);
        action.createParam(PARAM_ORGANIZATIONS).setDescription("Comma-separated list of organization keys").setExampleValue((Object)String.join((CharSequence)",", "my-org-1", "foocorp")).setMaxValuesAllowed(Integer.valueOf(500)).setRequired(false).setSince("6.3");
        action.createParam(PARAM_MEMBER).setDescription("Filter organizations based on whether the authenticated user is a member. If false, no filter applies.").setSince("7.0").setDefaultValue((Object)String.valueOf(false)).setBooleanPossibleValues();
        action.addPagingParams(100, 500);
    }

    public void handle(Request request, Response response) throws Exception {
        boolean isMember = request.mandatoryParamAsBoolean(PARAM_MEMBER);
        if (isMember) {
            this.userSession.checkLoggedIn();
        }
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationQuery dbQuery = this.buildDbQuery(request);
            int total = this.dbClient.organizationDao().countByQuery(dbSession, dbQuery);
            Common.Paging paging = SearchAction.buildWsPaging(request, total);
            List organizations = this.dbClient.organizationDao().selectByQuery(dbSession, dbQuery, Pagination.forPage((int)paging.getPageIndex()).andSize(paging.getPageSize()));
            Set<String> adminOrganizationUuids = this.searchOrganizationWithAdminPermission(dbSession);
            this.writeResponse(request, response, organizations, adminOrganizationUuids, paging);
        }
    }

    private OrganizationQuery buildDbQuery(Request request) {
        return OrganizationQuery.newOrganizationQueryBuilder().setKeys((Collection)request.paramAsStrings(PARAM_ORGANIZATIONS)).setMember(this.getUserIdIfFilterOnMembership(request)).build();
    }

    private Set<String> searchOrganizationWithAdminPermission(DbSession dbSession) {
        Integer userId = this.userSession.getUserId();
        return userId == null ? Collections.emptySet() : (Set)this.dbClient.organizationDao().selectByPermission(dbSession, userId, OrganizationPermission.ADMINISTER.getKey()).stream().map(OrganizationDto::getUuid).collect(MoreCollectors.toSet());
    }

    private void writeResponse(Request httpRequest, Response httpResponse, List<OrganizationDto> organizations, Set<String> adminOrganizationUuids, Common.Paging paging) {
        Organizations.SearchWsResponse.Builder response = Organizations.SearchWsResponse.newBuilder();
        response.setPaging(paging);
        Organizations.Organization.Builder wsOrganization = Organizations.Organization.newBuilder();
        organizations.forEach(o -> {
            boolean isAdmin = adminOrganizationUuids.contains(o.getUuid());
            wsOrganization.clear();
            wsOrganization.setIsAdmin(isAdmin);
            response.addOrganizations(this.wsSupport.toOrganization(wsOrganization, (OrganizationDto)o));
        });
        WsUtils.writeProtobuf((Message)response.build(), httpRequest, httpResponse);
    }

    private static Common.Paging buildWsPaging(Request request, int total) {
        return Common.Paging.newBuilder().setPageIndex(request.mandatoryParamAsInt("p")).setPageSize(request.mandatoryParamAsInt("ps")).setTotal(total).build();
    }

    @CheckForNull
    private Integer getUserIdIfFilterOnMembership(Request request) {
        boolean filterOnAuthenticatedUser = request.mandatoryParamAsBoolean(PARAM_MEMBER);
        return this.userSession.isLoggedIn() && filterOnAuthenticatedUser ? this.userSession.getUserId() : null;
    }
}

