/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureDtoToWsMeasure;
import org.sonar.server.measure.ws.MeasuresWsAction;
import org.sonar.server.measure.ws.MeasuresWsParametersBuilder;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Measures;

public class SearchAction
implements MeasuresWsAction {
    private static final int MAX_NB_PROJECTS = 100;
    private static final Set<String> ALLOWED_QUALIFIERS = ImmutableSet.of((Object)"TRK", (Object)"APP", (Object)"VW", (Object)"SVW");
    private final UserSession userSession;
    private final DbClient dbClient;

    public SearchAction(UserSession userSession, DbClient dbClient) {
        this.userSession = userSession;
        this.dbClient = dbClient;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("search").setInternal(true).setDescription("Search for project measures ordered by project names.<br>At most %d projects can be provided.<br>Returns the projects with the 'Browse' permission.", new Object[]{100}).setSince("6.2").setResponseExample(this.getClass().getResource("search-example.json")).setHandler((RequestHandler)this);
        MeasuresWsParametersBuilder.createMetricKeysParameter(action);
        action.createParam("projectKeys").setDescription("Comma-separated list of project, view or sub-view keys").setExampleValue((Object)String.join((CharSequence)",", "my_project", "another_project")).setRequired(true);
    }

    public void handle(Request httpRequest, Response httpResponse) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            Measures.SearchWsResponse response = new ResponseBuilder(httpRequest, dbSession).build();
            WsUtils.writeProtobuf((Message)response, httpRequest, httpResponse);
        }
    }

    private static class Builder {
        private List<String> metricKeys;
        private List<String> projectKeys;

        private Builder() {
        }

        public Builder setMetricKeys(List<String> metricKeys) {
            this.metricKeys = metricKeys;
            return this;
        }

        public Builder setProjectKeys(List<String> projectKeys) {
            this.projectKeys = projectKeys;
            return this;
        }

        public SearchRequest build() {
            Preconditions.checkArgument((this.metricKeys != null && !this.metricKeys.isEmpty() ? 1 : 0) != 0, (Object)"Metric keys must be provided");
            Preconditions.checkArgument((this.projectKeys != null && !this.projectKeys.isEmpty() ? 1 : 0) != 0, (Object)"Project keys must be provided");
            int nbComponents = this.projectKeys.size();
            Preconditions.checkArgument((nbComponents <= 100 ? 1 : 0) != 0, (String)"%s projects provided, more than maximum authorized (%s)", (Object[])new Object[]{nbComponents, 100});
            return new SearchRequest(this);
        }
    }

    private static class SearchRequest {
        private final List<String> metricKeys;
        private final List<String> projectKeys;

        public SearchRequest(Builder builder) {
            this.metricKeys = builder.metricKeys;
            this.projectKeys = builder.projectKeys;
        }

        public List<String> getMetricKeys() {
            return this.metricKeys;
        }

        public List<String> getProjectKeys() {
            return this.projectKeys;
        }

        public static Builder builder() {
            return new Builder();
        }
    }

    private class ResponseBuilder {
        private final DbSession dbSession;
        private final Request httpRequest;
        private SearchRequest request;
        private List<ComponentDto> projects;
        private List<MetricDto> metrics;
        private List<LiveMeasureDto> measures;

        ResponseBuilder(Request httpRequest, DbSession dbSession) {
            this.dbSession = dbSession;
            this.httpRequest = httpRequest;
        }

        Measures.SearchWsResponse build() {
            this.request = this.createRequest();
            this.projects = this.searchProjects();
            this.metrics = this.searchMetrics();
            this.measures = this.searchMeasures();
            return this.buildResponse();
        }

        private SearchRequest createRequest() {
            this.request = SearchRequest.builder().setMetricKeys(this.httpRequest.mandatoryParamAsStrings("metricKeys")).setProjectKeys(this.httpRequest.paramAsStrings("projectKeys")).build();
            return this.request;
        }

        private List<ComponentDto> searchProjects() {
            List<ComponentDto> componentDtos = this.searchByProjectKeys(this.dbSession, this.request.getProjectKeys());
            Preconditions.checkArgument((boolean)ALLOWED_QUALIFIERS.containsAll((Collection)componentDtos.stream().map(ComponentDto::qualifier).collect(MoreCollectors.toSet())), (String)"Only component of qualifiers %s are allowed", (Object[])new Object[]{ALLOWED_QUALIFIERS});
            return this.getAuthorizedProjects(componentDtos);
        }

        private List<ComponentDto> searchByProjectKeys(DbSession dbSession, List<String> projectKeys) {
            return SearchAction.this.dbClient.componentDao().selectByKeys(dbSession, projectKeys);
        }

        private List<ComponentDto> getAuthorizedProjects(List<ComponentDto> componentDtos) {
            return SearchAction.this.userSession.keepAuthorizedComponents("user", componentDtos);
        }

        private List<MetricDto> searchMetrics() {
            List dbMetrics = SearchAction.this.dbClient.metricDao().selectByKeys(this.dbSession, this.request.getMetricKeys());
            List metricKeys = (List)dbMetrics.stream().map(MetricDto::getKey).collect(MoreCollectors.toList());
            WsUtils.checkRequest(this.request.getMetricKeys().size() == dbMetrics.size(), "The following metrics are not found: %s", String.join((CharSequence)", ", this.difference(this.request.getMetricKeys(), metricKeys)));
            return dbMetrics;
        }

        private List<String> difference(Collection<String> expected, Collection<String> actual) {
            HashSet<String> actualSet = new HashSet<String>(actual);
            return (List)expected.stream().filter(value -> !actualSet.contains(value)).sorted(String::compareTo).collect(MoreCollectors.toList());
        }

        private List<LiveMeasureDto> searchMeasures() {
            return SearchAction.this.dbClient.liveMeasureDao().selectByComponentUuidsAndMetricIds(this.dbSession, (Collection)this.projects.stream().map(ComponentDto::uuid).collect(MoreCollectors.toArrayList((int)this.projects.size())), (Collection)this.metrics.stream().map(MetricDto::getId).collect(MoreCollectors.toArrayList((int)this.metrics.size())));
        }

        private Measures.SearchWsResponse buildResponse() {
            List<Measures.Measure> wsMeasures = this.buildWsMeasures();
            return Measures.SearchWsResponse.newBuilder().addAllMeasures(wsMeasures).build();
        }

        private List<Measures.Measure> buildWsMeasures() {
            Map componentsByUuid = this.projects.stream().collect(Collectors.toMap(ComponentDto::uuid, Function.identity()));
            Map<String, String> componentNamesByKey = this.projects.stream().collect(Collectors.toMap(ComponentDto::getDbKey, ComponentDto::name));
            Map metricsById = this.metrics.stream().collect(Collectors.toMap(MetricDto::getId, Function.identity()));
            Function<LiveMeasureDto, MetricDto> dbMeasureToDbMetric = dbMeasure -> (MetricDto)metricsById.get(dbMeasure.getMetricId());
            Function<Measures.Measure, String> byMetricKey = Measures.Measure::getMetric;
            Function<Measures.Measure, String> byComponentName = wsMeasure -> (String)componentNamesByKey.get(wsMeasure.getComponent());
            Measures.Measure.Builder measureBuilder = Measures.Measure.newBuilder();
            return (List)this.measures.stream().map(dbMeasure -> {
                MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, (MetricDto)dbMeasureToDbMetric.apply((LiveMeasureDto)dbMeasure), dbMeasure);
                measureBuilder.setComponent(((ComponentDto)componentsByUuid.get(dbMeasure.getComponentUuid())).getDbKey());
                Measures.Measure measure = measureBuilder.build();
                measureBuilder.clear();
                return measure;
            }).sorted(Comparator.comparing(byMetricKey).thenComparing(byComponentName)).collect(MoreCollectors.toList());
        }
    }
}

