/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;

class MetricDtoWithBestValue {
    private static final String LOWER_CASE_NEW_METRIC_PREFIX = "new_";
    private static final Set<String> QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE = ImmutableSortedSet.of((Comparable)((Object)"FIL"), (Comparable)((Object)"UTS"));
    private final MetricDto metric;
    private final LiveMeasureDto bestValue;

    MetricDtoWithBestValue(MetricDto metric) {
        this.metric = metric;
        LiveMeasureDto measure = new LiveMeasureDto().setMetricId(metric.getId().intValue());
        boolean isNewTypeMetric = metric.getKey().toLowerCase(Locale.ENGLISH).startsWith(LOWER_CASE_NEW_METRIC_PREFIX);
        if (isNewTypeMetric) {
            measure.setVariation(metric.getBestValue());
        } else {
            measure.setValue(metric.getBestValue());
        }
        this.bestValue = measure;
    }

    MetricDto getMetric() {
        return this.metric;
    }

    LiveMeasureDto getBestValue() {
        return this.bestValue;
    }

    static Predicate<ComponentDto> isEligibleForBestValue() {
        return component -> QUALIFIERS_ELIGIBLE_FOR_BEST_VALUE.contains(component.qualifier());
    }
}

