/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.ws;

import javax.annotation.Nullable;
import org.sonar.core.util.Protobuf;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.measure.MeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.server.measure.ws.MeasureValueFormatter;
import org.sonarqube.ws.Measures;

class MeasureDtoToWsMeasure {
    private MeasureDtoToWsMeasure() {
    }

    static void updateMeasureBuilder(Measures.Measure.Builder measureBuilder, MetricDto metricDto, MeasureDto measureDto) {
        Double value = measureDto.getValue();
        Double variation = measureDto.getVariation();
        MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, metricDto, value == null ? Double.NaN : value, measureDto.getData(), variation == null ? Double.NaN : variation);
    }

    static void updateMeasureBuilder(Measures.Measure.Builder measureBuilder, MetricDto metricDto, LiveMeasureDto measureDto) {
        Double value = measureDto.getValue();
        Double variation = measureDto.getVariation();
        MeasureDtoToWsMeasure.updateMeasureBuilder(measureBuilder, metricDto, value == null ? Double.NaN : value, measureDto.getDataAsString(), variation == null ? Double.NaN : variation);
    }

    static void updateMeasureBuilder(Measures.Measure.Builder measureBuilder, MetricDto metric, double doubleValue, @Nullable String stringValue, double variation) {
        measureBuilder.setMetric(metric.getKey());
        Double bestValue = metric.getBestValue();
        if (!Double.isNaN(doubleValue) || stringValue != null) {
            measureBuilder.setValue(MeasureValueFormatter.formatMeasureValue(doubleValue, stringValue, metric));
            Protobuf.setNullable((Object)bestValue, v -> measureBuilder.setBestValue(doubleValue == v));
        }
        Measures.PeriodValue.Builder periodBuilder = Measures.PeriodValue.newBuilder();
        if (Double.isNaN(variation)) {
            return;
        }
        Measures.PeriodValue.Builder builderForValue = periodBuilder.clear().setIndex(1).setValue(MeasureValueFormatter.formatNumericalValue(variation, metric));
        Protobuf.setNullable((Object)bestValue, v -> builderForValue.setBestValue(variation == v));
        measureBuilder.getPeriodsBuilder().addPeriodsValue(builderForValue);
    }
}

