/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.live;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import org.sonar.api.measures.Metric;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.BranchDto;
import org.sonar.db.component.BranchType;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.LiveMeasureDto;
import org.sonar.db.metric.MetricDto;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.qualitygate.QualityGateDto;
import org.sonar.server.measure.live.LiveQualityGateComputer;
import org.sonar.server.measure.live.MeasureMatrix;
import org.sonar.server.qualitygate.Condition;
import org.sonar.server.qualitygate.EvaluatedQualityGate;
import org.sonar.server.qualitygate.QualityGate;
import org.sonar.server.qualitygate.QualityGateConverter;
import org.sonar.server.qualitygate.QualityGateEvaluator;
import org.sonar.server.qualitygate.QualityGateFinder;
import org.sonar.server.qualitygate.ShortLivingBranchQualityGate;

public class LiveQualityGateComputerImpl
implements LiveQualityGateComputer {
    private final DbClient dbClient;
    private final QualityGateFinder qGateFinder;
    private final QualityGateEvaluator evaluator;

    public LiveQualityGateComputerImpl(DbClient dbClient, QualityGateFinder qGateFinder, QualityGateEvaluator evaluator) {
        this.dbClient = dbClient;
        this.qGateFinder = qGateFinder;
        this.evaluator = evaluator;
    }

    @Override
    public QualityGate loadQualityGate(DbSession dbSession, OrganizationDto organization, ComponentDto project, BranchDto branch) {
        if (branch.getBranchType() == BranchType.SHORT || branch.getBranchType() == BranchType.PULL_REQUEST) {
            return ShortLivingBranchQualityGate.GATE;
        }
        ComponentDto mainProject = project.getMainBranchProjectUuid() == null ? project : this.dbClient.componentDao().selectOrFailByKey(dbSession, project.getKey());
        QualityGateDto gateDto = this.qGateFinder.getQualityGate(dbSession, organization, mainProject).getQualityGate();
        Collection conditionDtos = this.dbClient.gateConditionDao().selectForQualityGate(dbSession, gateDto.getId().longValue());
        Set metricIds = (Set)conditionDtos.stream().map(c -> (int)c.getMetricId()).collect(MoreCollectors.toHashSet((int)conditionDtos.size()));
        Map metricsById = (Map)this.dbClient.metricDao().selectByIds(dbSession, metricIds).stream().collect(MoreCollectors.uniqueIndex(MetricDto::getId));
        Set conditions = (Set)conditionDtos.stream().map(conditionDto -> {
            String metricKey = ((MetricDto)metricsById.get((int)conditionDto.getMetricId())).getKey();
            Condition.Operator operator = Condition.Operator.fromDbValue(conditionDto.getOperator());
            boolean onLeak = Objects.equals(conditionDto.getPeriod(), 1);
            return new Condition(metricKey, operator, conditionDto.getErrorThreshold(), conditionDto.getWarningThreshold(), onLeak);
        }).collect(MoreCollectors.toHashSet((int)conditionDtos.size()));
        return new QualityGate(String.valueOf(gateDto.getId()), gateDto.getName(), conditions);
    }

    @Override
    public EvaluatedQualityGate refreshGateStatus(ComponentDto project, QualityGate gate, MeasureMatrix measureMatrix) {
        QualityGateEvaluator.Measures measures = metricKey -> {
            Optional<LiveMeasureDto> liveMeasureDto = measureMatrix.getMeasure(project, metricKey);
            if (!liveMeasureDto.isPresent()) {
                return Optional.empty();
            }
            MetricDto metric = measureMatrix.getMetric(liveMeasureDto.get().getMetricId());
            return Optional.of(new LiveMeasure(liveMeasureDto.get(), metric));
        };
        EvaluatedQualityGate evaluatedGate = this.evaluator.evaluate(gate, measures);
        measureMatrix.setValue(project, "alert_status", evaluatedGate.getStatus().name());
        measureMatrix.setValue(project, "quality_gate_details", QualityGateConverter.toJson(evaluatedGate));
        return evaluatedGate;
    }

    @Override
    public Set<String> getMetricsRelatedTo(QualityGate gate) {
        HashSet<String> metricKeys = new HashSet<String>();
        metricKeys.add("alert_status");
        metricKeys.add("quality_gate_details");
        metricKeys.addAll(this.evaluator.getMetricKeys(gate));
        return metricKeys;
    }

    private static class LiveMeasure
    implements QualityGateEvaluator.Measure {
        private final LiveMeasureDto dto;
        private final MetricDto metric;

        LiveMeasure(LiveMeasureDto dto, MetricDto metric) {
            this.dto = dto;
            this.metric = metric;
        }

        @Override
        public Metric.ValueType getType() {
            return Metric.ValueType.valueOf((String)this.metric.getValueType());
        }

        @Override
        public OptionalDouble getValue() {
            if (this.dto.getValue() == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(this.dto.getValue());
        }

        @Override
        public Optional<String> getStringValue() {
            return Optional.ofNullable(this.dto.getTextValue());
        }

        @Override
        public OptionalDouble getLeakValue() {
            if (this.dto.getVariation() == null) {
                return OptionalDouble.empty();
            }
            return OptionalDouble.of(this.dto.getVariation());
        }
    }
}

