/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.measure.custom.ws;

import com.google.common.base.Preconditions;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.component.ComponentDto;
import org.sonar.db.measure.custom.CustomMeasureDto;
import org.sonar.server.measure.custom.ws.CustomMeasuresWsAction;
import org.sonar.server.user.UserSession;

public class DeleteAction
implements CustomMeasuresWsAction {
    private static final String ACTION = "delete";
    public static final String PARAM_ID = "id";
    private final DbClient dbClient;
    private final UserSession userSession;

    public DeleteAction(DbClient dbClient, UserSession userSession) {
        this.dbClient = dbClient;
        this.userSession = userSession;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction(ACTION).setPost(true).setHandler((RequestHandler)this).setSince("5.2").setDescription("Delete a custom measure.<br /> Requires 'Administer System' permission or 'Administer' permission on the project.");
        action.createParam(PARAM_ID).setDescription("Id").setExampleValue((Object)"24").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        long id = request.mandatoryParamAsLong(PARAM_ID);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            CustomMeasureDto customMeasure = this.dbClient.customMeasureDao().selectById(dbSession, id);
            Preconditions.checkArgument((customMeasure != null ? 1 : 0) != 0, (String)"Custom measure with id '%s' does not exist", (Object[])new Object[]{id});
            this.checkPermission(dbSession, customMeasure);
            this.dbClient.customMeasureDao().delete(dbSession, id);
            dbSession.commit();
        }
        response.noContent();
    }

    private void checkPermission(DbSession dbSession, CustomMeasureDto customMeasure) {
        this.userSession.checkLoggedIn();
        ComponentDto component = this.dbClient.componentDao().selectOrFailByUuid(dbSession, customMeasure.getComponentUuid());
        this.userSession.checkComponentPermission("admin", component);
    }
}

